/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class ChestConformationCheck
extends ConformationCheck {
    public ChestConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.chest.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.chest.description");
    }

    @Override
    public double getConformationPercentage() {
        double chestWidth = this.getMeasurement(ConformationMeasurementType.CHESTWIDTH);
        if (chestWidth < 15.0) {
            return chestWidth / 15.0 * 100.0;
        }
        if (chestWidth > 15.0) {
            return 15.0 / chestWidth * 100.0;
        }
        return 100.0;
    }

    @Override
    boolean affectsStamina() {
        return true;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.CHEST;
    }
}

