/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.core.conformation.check.ConformationCheckRating;
import com.equestricraft.core.conformation.check.ConformationCheckResult;
import com.equestricraft.core.conformation.check.ConformationRatingThresholdSession;
import com.equestricraft.core.conformation.check.ConformationRatingThresholds;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public abstract class ConformationCheck {
    final EQHorse horse;
    @Service
    private static ConformationRatingThresholdSession conformationRatingThresholdSession;

    ConformationCheck(EQHorse horse) {
        this.horse = horse;
    }

    public abstract String getName();

    public abstract String getDescription();

    public final ConformationCheckResult checkConformation() {
        ConformationCheckRating rating = this.getConformationRating();
        double speed = this.getSpeedEffectPercentage();
        double jump = this.getJumpEffectPercentage();
        double stamina = this.getStaminaEffectPercentage();
        return new ConformationCheckResult(this, rating, speed, jump, stamina);
    }

    public final ConformationCheckRating getConformationRating() {
        double percentage = this.getConformationPercentage();
        return this.getResultForPercentage(percentage);
    }

    public abstract double getConformationPercentage();

    private ConformationCheckRating getResultForPercentage(double percentage) {
        ConformationRatingThresholds threshold = conformationRatingThresholdSession.getThresholdsForTypeForHorse(this.getType(), this.horse);
        return threshold.getRating(percentage);
    }

    public double getSpeedEffectPercentage() {
        if (this.affectsSpeed()) {
            return this.calculateStatEffectPercentage();
        }
        return 100.0;
    }

    boolean affectsSpeed() {
        return false;
    }

    public double getJumpEffectPercentage() {
        if (this.affectsJump()) {
            return this.calculateStatEffectPercentage();
        }
        return 100.0;
    }

    boolean affectsJump() {
        return false;
    }

    public double getStaminaEffectPercentage() {
        if (this.affectsStamina()) {
            return this.calculateStatEffectPercentage();
        }
        return 100.0;
    }

    boolean affectsStamina() {
        return false;
    }

    private double calculateStatEffectPercentage() {
        double percentage = this.getConformationPercentage();
        if (percentage >= 75.0) {
            double boost = (percentage - 75.0) * 2.0;
            return 100.0 + boost;
        }
        if (percentage >= 25.0) {
            return 100.0;
        }
        double reduction = (25.0 - percentage) * 2.0;
        return 100.0 - reduction;
    }

    abstract ConformationCheckType getType();

    protected final double getMeasurement(ConformationMeasurementType measurement) {
        return this.horse.getConformation().getMeasurement(measurement);
    }
}

