/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.core.conformation.check.ConformationCheckSettings;
import com.equestricraft.core.conformation.check.ConformationRatingThresholdProvider;
import com.equestricraft.core.conformation.check.ConformationRatingThresholdSession;
import com.equestricraft.core.conformation.check.ConformationRatingThresholds;
import com.equestricraft.core.horse.EQHorse;
import java.util.OptionalDouble;
import java.util.function.ToDoubleFunction;

public class ConformationRatingThresholdSessionImpl
implements ConformationRatingThresholdSession {
    @Service
    private ServiceInstance<ConformationRatingThresholdProvider> providers;

    @Override
    public ConformationRatingThresholds getThresholdsForTypeForHorse(final ConformationCheckType type, final EQHorse horse) {
        return new ConformationRatingThresholds(){

            @Override
            public double getVeryGoodThreshold() {
                return ConformationRatingThresholdSessionImpl.this.getAverageThreshold(p -> p.getVeryGoodThreshold(type, horse)).orElseGet(ConformationCheckSettings::getVeryGoodThreshold);
            }

            @Override
            public double getGoodThreshold() {
                return ConformationRatingThresholdSessionImpl.this.getAverageThreshold(p -> p.getGoodThreshold(type, horse)).orElseGet(ConformationCheckSettings::getGoodThreshold);
            }

            @Override
            public double getOkThreshold() {
                return ConformationRatingThresholdSessionImpl.this.getAverageThreshold(p -> p.getOkThreshold(type, horse)).orElseGet(ConformationCheckSettings::getOkThreshold);
            }

            @Override
            double getPoorThreshold() {
                return ConformationRatingThresholdSessionImpl.this.getAverageThreshold(p -> p.getPoorThreshold(type, horse)).orElseGet(ConformationCheckSettings::getPoorThreshold);
            }
        };
    }

    private OptionalDouble getAverageThreshold(ToDoubleFunction<ConformationRatingThresholdProvider> provider) {
        return this.providers.stream().mapToDouble(provider).average();
    }
}

