/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class FrontLegsConformationCheck
extends ConformationCheck {
    public FrontLegsConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.frontlegs.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.frontlegs.description");
    }

    @Override
    public double getConformationPercentage() {
        double frontLegsAngle = this.getMeasurement(ConformationMeasurementType.FRONTLEGSANGLE);
        if (frontLegsAngle < 1.2) {
            return frontLegsAngle / 1.2 * 100.0;
        }
        if (frontLegsAngle > 1.2) {
            return 1.2 / frontLegsAngle * 100.0;
        }
        return 100.0;
    }

    @Override
    boolean affectsSpeed() {
        return true;
    }

    @Override
    boolean affectsJump() {
        return true;
    }

    @Override
    boolean affectsStamina() {
        return true;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.FRONT_LEGS;
    }
}

