/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class HeadConformationCheck
extends ConformationCheck {
    public HeadConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.head.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.head.description");
    }

    @Override
    public double getConformationPercentage() {
        double neckLength;
        double targetHeadLength;
        double headLength = this.getMeasurement(ConformationMeasurementType.HEAD);
        if (headLength < (targetHeadLength = (neckLength = this.getMeasurement(ConformationMeasurementType.NECK)) / 3.0 * 2.0)) {
            return headLength / targetHeadLength * 100.0;
        }
        if (headLength > targetHeadLength) {
            return targetHeadLength / headLength * 100.0;
        }
        return 100.0;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.HEAD;
    }
}

