/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class HindLegsConformationCheck
extends ConformationCheck {
    public HindLegsConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.hindlegs.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.hindlegs.description");
    }

    @Override
    public double getConformationPercentage() {
        double hindLegsAngle = this.getMeasurement(ConformationMeasurementType.HINDLEGSANGLE);
        if (hindLegsAngle < 1.2) {
            return hindLegsAngle / 1.2 * 100.0;
        }
        if (hindLegsAngle > 1.2) {
            return 1.2 / hindLegsAngle * 100.0;
        }
        return 100.0;
    }

    @Override
    boolean affectsSpeed() {
        return true;
    }

    @Override
    boolean affectsJump() {
        return true;
    }

    @Override
    boolean affectsStamina() {
        return true;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.HIND_LEGS;
    }
}

