/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class HindquartersConformationCheck
extends ConformationCheck {
    public HindquartersConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.hindquarters.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.hindquarters.description");
    }

    @Override
    public double getConformationPercentage() {
        double quartersLength = this.getMeasurement(ConformationMeasurementType.HINDQUARTERS);
        double bodyLength = this.getMeasurement(ConformationMeasurementType.BODY_LENGTH);
        double targetQuartersLength = bodyLength / 3.0;
        if (targetQuartersLength < quartersLength) {
            return targetQuartersLength / quartersLength * 100.0;
        }
        if (targetQuartersLength > quartersLength) {
            return quartersLength / targetQuartersLength * 100.0;
        }
        return 100.0;
    }

    @Override
    boolean affectsSpeed() {
        return true;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.HINDQUARTERS;
    }
}

