/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class HoovesConformationCheck
extends ConformationCheck {
    public HoovesConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.hooves.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.hooves.description");
    }

    @Override
    public double getConformationPercentage() {
        double hoovesAngle = this.getMeasurement(ConformationMeasurementType.HOOVES);
        return (hoovesAngle -= 40.0) / 15.0 * 100.0;
    }

    @Override
    boolean affectsSpeed() {
        return true;
    }

    @Override
    boolean affectsJump() {
        return true;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.HOOVES;
    }
}

