/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class NeckConformationCheck
extends ConformationCheck {
    public NeckConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.neck.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.neck.description");
    }

    @Override
    public double getConformationPercentage() {
        double bodyTotalLength;
        double targetNeckLength;
        double neckLength = this.getMeasurement(ConformationMeasurementType.NECK);
        if (neckLength < (targetNeckLength = (bodyTotalLength = this.getMeasurement(ConformationMeasurementType.BODY_TOTAL_LENGTH)) / 3.0)) {
            return neckLength / targetNeckLength * 100.0;
        }
        if (neckLength > targetNeckLength) {
            return targetNeckLength / neckLength * 100.0;
        }
        return 100.0;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.NECK;
    }
}

