/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.check;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.EQHorse;

public class ShouldersConformationCheck
extends ConformationCheck {
    public ShouldersConformationCheck(EQHorse horse) {
        super(horse);
    }

    @Override
    public String getName() {
        return I18n.getLabel("conformation-check.type.shoulders.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("conformation-check.type.shoulders.description");
    }

    @Override
    public double getConformationPercentage() {
        double shouldersAngle = this.getMeasurement(ConformationMeasurementType.SHOULDERS);
        return (shouldersAngle -= 40.0) / 15.0 * 100.0;
    }

    @Override
    ConformationCheckType getType() {
        return ConformationCheckType.SHOULDERS;
    }
}

