/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.conformation.measurement;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.conformation.measurement.ConformationMeasurement;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import java.util.List;

public class ConformationMeasurementDatabase
implements RepositoryDatasource<ConformationMeasurement, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_MINIMUM_INITIAL_VALUE = "MINIMUM_INITIAL_VALUE";
    private static final String COLUMN_MAXIMUM_INITIAL_VALUE = "MAXIMUM_INITIAL_VALUE";
    private static final String COLUMN_PARENT_RANDOM_OFFSET_PERCENTAGE = "PARENT_RANDOM_OFFSET_PERCENTAGE";
    private static final String COLUMN_UNIT = "UNIT";

    @Override
    public List<ConformationMeasurement> retrieveAll() {
        return Query.selectAllFrom("CONFORMATION_MEASUREMENT").getList(this::getFromResultRow);
    }

    private ConformationMeasurement getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        ConformationMeasurementType type = ConformationMeasurementType.getByIdentifier(row.getString(COLUMN_IDENTIFIER));
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        double minimumInitialValue = row.getDouble(COLUMN_MINIMUM_INITIAL_VALUE);
        double maximumInitialValue = row.getDouble(COLUMN_MAXIMUM_INITIAL_VALUE);
        double parentRandomOffsetPercentage = row.getDouble(COLUMN_PARENT_RANDOM_OFFSET_PERCENTAGE);
        String unit = row.getString(COLUMN_UNIT);
        return new ConformationMeasurement(id, type, name, description, minimumInitialValue, maximumInitialValue, parentRandomOffsetPercentage, unit);
    }
}

