/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.dailyjoin;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.dailyjoin.DailyJoinReward;
import java.util.List;

public class DailyJoinRewardDatabase
implements RepositoryDatasource<DailyJoinReward, Integer> {
    @Override
    public List<DailyJoinReward> retrieveAll() {
        return Query.selectAllFrom("DAILY_JOIN_REWARD").where(QueryColumn.column("ENABLED", true)).getList(this::getFromResultRow);
    }

    private DailyJoinReward getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        int dayStreak = row.getInt("DAY_STREAK");
        int xpReward = row.getInt("XP_REWARD");
        double moneyReward = row.getDouble("MONEY_REWARD");
        String script = row.getString("SCRIPT");
        String message = row.getNullableString("MESSAGE");
        return new DailyJoinReward(id, name, dayStreak, xpReward, moneyReward, script, message);
    }
}

