/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.discipline;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.discipline.Discipline;
import java.util.List;

public class DisciplineDatabase
implements RepositoryDatasource<Discipline, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_SCRIPT = "SCRIPT";
    private static final String COLUMN_ENABLED = "ENABLED";
    private static final String COLUMN_DISCIPLINE_ID = "DISCIPLINE_ID";
    private static final String COLUMN_SKILL_ID = "SKILL_ID";

    @Override
    public List<Discipline> retrieveAll() {
        return Query.selectAllFrom("DISCIPLINE").where(QueryColumn.column(COLUMN_ENABLED, true)).getList(this::getFromResultRow);
    }

    private Discipline getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        String script = row.getString(COLUMN_SCRIPT);
        List<Integer> skillIds = this.getSkillIdsForDiscipline(id);
        return new Discipline(id, name, identifier, description, script, skillIds);
    }

    private List<Integer> getSkillIdsForDiscipline(int disciplineId) {
        return Query.selectAllFrom("DISCIPLINE_SKILL").where(QueryColumn.column(COLUMN_DISCIPLINE_ID, disciplineId)).getList(s -> s.getInt(COLUMN_SKILL_ID));
    }
}

