/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.discoverlocation;

import com.equestricraft.api.common.APIDiscoverLocationDto;
import com.equestricraft.api.common.APIDiscoverLocationsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.discoverlocation.APIDiscoverLocationDtoImpl;
import com.equestricraft.core.discoverlocation.DiscoverLocation;
import com.equestricraft.core.discoverlocation.DiscoverLocationRepository;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public class APIDiscoverLocationsDtoImpl
extends MapAdapter<String, APIDiscoverLocationDto>
implements APIDiscoverLocationsDto {
    @Service
    private static DiscoverLocationRepository discoverLocationRepository;

    @Override
    public int size() {
        return discoverLocationRepository.getTotalSize();
    }

    @Override
    public APIDiscoverLocationDto get(Object key) {
        Optional<DiscoverLocation> location = this.getFromKey(key);
        return location.map(APIDiscoverLocationDtoImpl::new).orElse(null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getFromKey(key).isPresent();
    }

    private Optional<DiscoverLocation> getFromKey(Object key) {
        if (key instanceof String) {
            String identifier = (String)key;
            return discoverLocationRepository.findByIdentifier(identifier);
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return Optional.ofNullable((DiscoverLocation)discoverLocationRepository.findByKey(id));
        }
        throw new IllegalArgumentException("Invalid key provided");
    }

    @Override
    public Set<Map.Entry<String, APIDiscoverLocationDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIDiscoverLocationDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIDiscoverLocationDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIDiscoverLocationsDtoImpl.this.size();
        }

        static final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIDiscoverLocationDto>> {
            private final Iterator<DiscoverLocation> discoverLocationIterator = discoverLocationRepository.iterator();

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.discoverLocationIterator.hasNext();
            }

            @Override
            public Map.Entry<String, APIDiscoverLocationDto> next() {
                if (this.hasNext()) {
                    DiscoverLocation location = this.discoverLocationIterator.next();
                    APIDiscoverLocationDtoImpl dto = new APIDiscoverLocationDtoImpl(location);
                    return Map.entry(location.getIdentifier(), dto);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

