/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.discoverlocation;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.worldarea.WorldArea;
import com.equestricraft.core.discoverlocation.DiscoverLocation;
import java.util.List;

public class DiscoverLocationDatabase
implements RepositoryDatasource<DiscoverLocation, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_WEIGHT = "WEIGHT";
    private static final String COLUMN_XP_REWARD = "XP_REWARD";
    private static final String COLUMN_WORLD_AREA = "WORLD_AREA";
    private static final String COLUMN_LAST_ADDRESS_COMPONENT = "LAST_ADDRESS_COMPONENT";
    private static final String COLUMN_HIDE_FROM_ADDRESS = "HIDE_FROM_ADDRESS";
    private static final String COLUMN_ANNOUNCE_DISCOVERY = "ANNOUNCE_DISCOVERY";
    private static final String COLUMN_SHOW_IN_COMPENDIUM = "SHOW_IN_COMPENDIUM";
    private static final String COLUMN_ENABLED = "ENABLED";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";

    @Override
    public List<DiscoverLocation> retrieveAll() {
        return Query.selectAllFrom("DISCOVER_LOCATION").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getFromResultRow);
    }

    private DiscoverLocation getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        int weight = row.getInt(COLUMN_WEIGHT);
        int xpReward = row.getInt(COLUMN_XP_REWARD);
        WorldArea worldArea = row.getWorldArea(COLUMN_WORLD_AREA);
        boolean lastAddressComponent = row.getBoolean(COLUMN_LAST_ADDRESS_COMPONENT);
        boolean hideFromAddress = row.getBoolean(COLUMN_HIDE_FROM_ADDRESS);
        boolean announceDiscovery = row.getBoolean(COLUMN_ANNOUNCE_DISCOVERY);
        boolean showInCompendium = row.getBoolean(COLUMN_SHOW_IN_COMPENDIUM);
        boolean enabled = row.getBoolean(COLUMN_ENABLED);
        return new DiscoverLocation(id, name, identifier, description, weight, xpReward, worldArea, lastAddressComponent, hideFromAddress, announceDiscovery, showInCompendium, enabled);
    }
}

