/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.DualAccountEconomyResponse;
import com.equestricraft.core.economy.Economy;
import com.equestricraft.core.economy.EconomyBalanceChangeEvent;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.NotEnoughMoneyException;
import com.equestricraft.core.economy.SameAccountException;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountClosedException;
import com.equestricraft.core.economy.account.BankAccountHoldingEntity;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.economy.account.NoBankAccountException;
import com.equestricraft.core.economy.transaction.BankAccountTransactionSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;
import java.util.Date;

@TransactionManagement
public class EconomyImpl
implements Economy {
    @Service
    private BankAccountSession bankAccountSession;
    @Service
    private BankAccountTransactionSession bankAccountTransactionSession;
    private static final Log log = Log.getLogger(EconomyImpl.class.getName());

    @Override
    public double getBalance(ECPlayer player) {
        return this.bankAccountSession.getPlayersMainAccount(player).getBalance();
    }

    @Override
    public double getBalance(BankAccountHoldingEntity bankAccountHoldingEntity) throws NoBankAccountException {
        BankAccount account = this.bankAccountSession.getAccountById(bankAccountHoldingEntity.requireBankAccountId());
        return account.getBalance();
    }

    @Override
    public boolean hasBalance(ECPlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    @Override
    public boolean hasBalance(BankAccountHoldingEntity bankAccountHoldingEntity, double amount) throws NoBankAccountException {
        return this.getBalance(bankAccountHoldingEntity) >= amount;
    }

    @Override
    public SingleAccountEconomyResponse deposit(ECPlayer player, double amount, String reason, String sourceDescription) {
        BankAccount currentAccount = this.bankAccountSession.getPlayersMainAccount(player);
        try {
            SingleAccountEconomyResponse response = this.deposit(currentAccount, amount, reason, sourceDescription);
            this.fireBalanceChangeEvent(player, response.balance());
            return response;
        }
        catch (EconomyException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public SingleAccountEconomyResponse deposit(BankAccountHoldingEntity bankAccountHoldingEntity, double amount, String reason, String sourceDescription) throws EconomyException {
        BankAccount account = this.bankAccountSession.getAccountById(bankAccountHoldingEntity.requireBankAccountId());
        return this.deposit(account, amount, reason, sourceDescription);
    }

    private SingleAccountEconomyResponse deposit(BankAccount bankAccount, double amount, String reason, String sourceDescription) throws BankAccountClosedException {
        this.ensureZeroOrGreater(amount);
        this.ensureReasonCharacterLimit(reason);
        this.ensureAccountNotClosed(bankAccount);
        amount = EconomyUtilities.roundCurrencyValue(amount);
        double newBalance = bankAccount.getBalance() + amount;
        Date now = new Date();
        this.bankAccountSession.updateAccountsBalance(bankAccount, newBalance);
        this.bankAccountTransactionSession.addTransaction(bankAccount, now, amount, reason, sourceDescription);
        String amountFormatted = EconomyUtilities.formatCurrency(amount);
        String newBalanceFormatted = EconomyUtilities.formatCurrency(newBalance);
        log.info("Deposited {} into account ID {}", (Object)amount, (Object)bankAccount.getId());
        return new SingleAccountEconomyResponse(amount, newBalance, amountFormatted, newBalanceFormatted);
    }

    @Override
    public SingleAccountEconomyResponse withdraw(ECPlayer player, double amount, String reason, String sourceDescription) throws EconomyException {
        BankAccount currentAccount = this.bankAccountSession.getPlayersMainAccount(player);
        SingleAccountEconomyResponse response = this.withdraw(currentAccount, amount, reason, sourceDescription);
        this.fireBalanceChangeEvent(player, response.balance());
        return response;
    }

    @Override
    public SingleAccountEconomyResponse withdraw(BankAccountHoldingEntity bankAccountHoldingEntity, double amount, String reason, String sourceDescription) throws EconomyException {
        BankAccount account = this.bankAccountSession.getAccountById(bankAccountHoldingEntity.requireBankAccountId());
        return this.withdraw(account, amount, reason, sourceDescription);
    }

    private SingleAccountEconomyResponse withdraw(BankAccount bankAccount, double amount, String reason, String sourceDescription) throws EconomyException {
        this.ensureZeroOrGreater(amount);
        this.ensureReasonCharacterLimit(reason);
        this.ensureAccountNotClosed(bankAccount);
        amount = EconomyUtilities.roundCurrencyValue(amount);
        double newBalance = bankAccount.getBalance() - amount;
        if (newBalance < 0.0) {
            throw new NotEnoughMoneyException();
        }
        Date now = new Date();
        this.bankAccountSession.updateAccountsBalance(bankAccount, newBalance);
        this.bankAccountTransactionSession.addTransaction(bankAccount, now, -amount, reason, sourceDescription);
        String amountFormatted = EconomyUtilities.formatCurrency(amount);
        String newBalanceFormatted = EconomyUtilities.formatCurrency(newBalance);
        log.info("Withdrawn {} from account ID {}", (Object)amount, (Object)bankAccount.getId());
        return new SingleAccountEconomyResponse(amount, newBalance, amountFormatted, newBalanceFormatted);
    }

    @Override
    public DualAccountEconomyResponse transfer(ECPlayer fromPlayer, ECPlayer toPlayer, double amount, String reason) throws EconomyException {
        BankAccount fromCurrentAccount = this.bankAccountSession.getPlayersMainAccount(fromPlayer);
        BankAccount toCurrentAccount = this.bankAccountSession.getPlayersMainAccount(toPlayer);
        DualAccountEconomyResponse response = this.transfer(fromCurrentAccount, toCurrentAccount, amount, reason);
        this.fireBalanceChangeEvent(fromPlayer, response.fromAccountBalance());
        this.fireBalanceChangeEvent(toPlayer, response.toAccountBalance());
        return response;
    }

    @Override
    public DualAccountEconomyResponse transfer(BankAccountHoldingEntity fromEntity, BankAccountHoldingEntity toEntity, double amount, String reason) throws EconomyException {
        BankAccount fromAccount = this.bankAccountSession.getAccountById(fromEntity.requireBankAccountId());
        BankAccount toAccount = this.bankAccountSession.getAccountById(toEntity.requireBankAccountId());
        return this.transfer(fromAccount, toAccount, amount, reason);
    }

    @Override
    public DualAccountEconomyResponse transfer(ECPlayer fromPlayer, BankAccountHoldingEntity toEntity, double amount, String reason) throws EconomyException {
        BankAccount fromAccount = this.bankAccountSession.getPlayersMainAccount(fromPlayer);
        BankAccount toAccount = this.bankAccountSession.getAccountById(toEntity.requireBankAccountId());
        DualAccountEconomyResponse response = this.transfer(fromAccount, toAccount, amount, reason);
        this.fireBalanceChangeEvent(fromPlayer, response.fromAccountBalance());
        return response;
    }

    @Override
    public DualAccountEconomyResponse transfer(BankAccountHoldingEntity fromEntity, ECPlayer toPlayer, double amount, String reason) throws EconomyException {
        BankAccount fromAccount = this.bankAccountSession.getAccountById(fromEntity.requireBankAccountId());
        BankAccount toAccount = this.bankAccountSession.getPlayersMainAccount(toPlayer);
        DualAccountEconomyResponse response = this.transfer(fromAccount, toAccount, amount, reason);
        this.fireBalanceChangeEvent(toPlayer, response.toAccountBalance());
        return response;
    }

    @Override
    public DualAccountEconomyResponse transfer(BankAccount fromAccount, BankAccount toAccount, double amount, String reason) throws EconomyException {
        this.ensureZeroOrGreater(amount);
        this.ensureReasonCharacterLimit(reason);
        this.ensureAccountNotClosed(fromAccount);
        this.ensureAccountNotClosed(toAccount);
        amount = EconomyUtilities.roundCurrencyValue(amount);
        if (fromAccount.getId() == toAccount.getId()) {
            throw new SameAccountException();
        }
        double fromNewBalance = fromAccount.getBalance() - amount;
        double toNewBalance = toAccount.getBalance() + amount;
        if (fromNewBalance < 0.0) {
            throw new NotEnoughMoneyException();
        }
        Date now = new Date();
        this.bankAccountSession.updateAccountsBalance(fromAccount, fromNewBalance);
        this.bankAccountSession.updateAccountsBalance(toAccount, toNewBalance);
        this.bankAccountTransactionSession.addTransaction(toAccount, now, amount, reason, fromAccount, null);
        this.bankAccountTransactionSession.addTransaction(fromAccount, now, -amount, reason, toAccount, null);
        String amountFormatted = EconomyUtilities.formatCurrency(amount);
        String fromNewBalanceFormatted = EconomyUtilities.formatCurrency(fromNewBalance);
        String toNewBalanceFormatted = EconomyUtilities.formatCurrency(toNewBalance);
        log.info("Transferred {} from the account ID {} to account ID {}", amount, fromAccount.getId(), toAccount.getId());
        return new DualAccountEconomyResponse(amount, fromNewBalance, toNewBalance, amountFormatted, fromNewBalanceFormatted, toNewBalanceFormatted);
    }

    private void ensureZeroOrGreater(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException(I18n.getLabel("economy.zero-or-greater"));
        }
    }

    private void ensureReasonCharacterLimit(String reason) {
        if (reason.length() > 255) {
            throw new IllegalArgumentException(I18n.getLabel("economy.transaction-reason-character-limit", 255));
        }
    }

    private void ensureAccountNotClosed(BankAccount bankAccount) throws BankAccountClosedException {
        if (bankAccount.isClosed()) {
            throw new BankAccountClosedException(I18n.getLabel("economy.bank-account.closed"));
        }
    }

    private void fireBalanceChangeEvent(ECPlayer player, double newBalance) {
        EconomyBalanceChangeEvent event = new EconomyBalanceChangeEvent(player, newBalance);
        ECEventBus.post(event);
    }
}

