/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.DualAccountEconomyResponse;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyService;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerService;

public class EconomyServiceImpl
implements EconomyService {
    @Service
    private PlayerService playerService;

    @Override
    public Response deposit(String ign, double amount, String reason) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        return this.deposit(player, amount, reason);
    }

    @Override
    public Response deposit(ECPlayer player, double amount, String reason) {
        SingleAccountEconomyResponse response = player.getEconomy().deposit(amount, reason, "Custom");
        player.notify(I18n.getLabel("economy.money-received.success", response.amountFormatted(), response.balanceFormatted()));
        return ResponseFactory.success(I18n.getLabel("economy.money-given.success", response.amountFormatted(), player.getIgn(), response.balanceFormatted()));
    }

    @Override
    public Response withdraw(String ign, double amount, String reason) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        return this.withdraw(player, amount, reason);
    }

    @Override
    public Response withdraw(ECPlayer player, double amount, String reason) {
        try {
            SingleAccountEconomyResponse response = player.getEconomy().withdraw(amount, reason, "Custom");
            player.notify(I18n.getLabel("economy.money-withdrawn.success", response.amountFormatted(), response.balanceFormatted()));
            return ResponseFactory.success(I18n.getLabel("economy.money-taken.success", response.amountFormatted(), player.getIgn(), response.balanceFormatted()));
        }
        catch (EconomyException ex) {
            return ResponseFactory.fail(I18n.getLabel("economy.cannot-withdraw.prompt.title"), ex);
        }
    }

    @Override
    public Response transfer(ECPlayer fromPlayer, String toPlayerIgn, double amount, String reason) {
        CorePlayer toPlayer = this.playerService.retrievePlayerByIgn(toPlayerIgn);
        if (fromPlayer.getInductionMode().isIncomplete()) {
            return ResponseFactory.fail(I18n.getLabel("economy.pay.not-finished-induction"));
        }
        try {
            DualAccountEconomyResponse response = fromPlayer.getEconomy().sendTo(toPlayer, amount, reason);
            toPlayer.notify(I18n.getLabel("economy.transfer-received.success", EconomyUtilities.formatCurrency(response.amount()), fromPlayer.getIgn(), EconomyUtilities.formatCurrency(response.toAccountBalance())));
            return ResponseFactory.success(I18n.getLabel("economy.transfer-sent.success", EconomyUtilities.formatCurrency(response.amount()), toPlayer.getIgn(), EconomyUtilities.formatCurrency(response.fromAccountBalance())));
        }
        catch (EconomyException ex) {
            return ResponseFactory.fail(I18n.getLabel("economy.cannot-pay.prompt.title"), ex);
        }
    }
}

