/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy;

import com.equestricraft.core.economy.EconomySettings;
import java.text.DecimalFormat;

public class EconomyUtilities {
    public static String formatCurrency(double value) {
        String symbol = EconomySettings.getCurrencySymbol();
        if (value < 0.0) {
            double abs = Math.abs(value);
            return String.format("-%s%s", symbol, EconomyUtilities.formatNoSymbol(abs));
        }
        return String.format("%s%s", symbol, EconomyUtilities.formatNoSymbol(value));
    }

    private static String formatNoSymbol(double value) {
        String format = EconomySettings.getValueFormat();
        DecimalFormat df = new DecimalFormat(format);
        return df.format(value);
    }

    public static double roundCurrencyValue(double value) {
        String formatted = EconomyUtilities.formatNoSymbol(value);
        formatted = formatted.replace(",", "");
        return Double.parseDouble(formatted);
    }

    private EconomyUtilities() {
    }
}

