/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy.account;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.BankAccountType;
import com.equestricraft.core.economy.account.BankAccount;
import java.util.List;
import java.util.Optional;

public class BankAccountDatabase {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_ACCOUNT_TYPE = "ACCOUNT_TYPE";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_BALANCE = "BALANCE";
    private static final String COLUMN_CLOSED = "CLOSED";

    public void addBankAccount(BankAccount bankAccount) {
        Query.insertInto("BANK_ACCOUNT").columns(QueryColumn.column(COLUMN_NAME, bankAccount.getName()), QueryColumn.column(COLUMN_ACCOUNT_TYPE, bankAccount.getBankAccountType()), QueryColumn.column(COLUMN_PLAYER_ID, bankAccount.getPlayerId()), QueryColumn.column(COLUMN_BALANCE, bankAccount.getBalance()), QueryColumn.column(COLUMN_CLOSED, bankAccount.isClosed())).executeGetGeneratedKey(bankAccount::setId);
    }

    public void updateAccountName(long accountId, String name) {
        Query.update("BANK_ACCOUNT").set(QueryColumn.column(COLUMN_NAME, name)).where(QueryColumn.column(COLUMN_ID, accountId)).execute();
    }

    public void updateAccountBalance(int accountId, double alterValue) {
        Query.update("BANK_ACCOUNT").set(QueryColumn.column(COLUMN_BALANCE, alterValue)).where(QueryColumn.column(COLUMN_ID, accountId)).execute();
    }

    public void updateAccountOwner(int accountId, int ownerId) {
        Query.update("BANK_ACCOUNT").set(QueryColumn.column(COLUMN_PLAYER_ID, ownerId)).where(QueryColumn.column(COLUMN_ID, accountId)).execute();
    }

    public void updateAccountClosed(int accountId, boolean closed) {
        Query.update("BANK_ACCOUNT").set(QueryColumn.column(COLUMN_CLOSED, closed)).where(QueryColumn.column(COLUMN_ID, accountId)).execute();
    }

    public Optional<BankAccount> getOpenBankAccountByPlayerAndName(int playerId, String name) {
        return Query.selectAllFrom("BANK_ACCOUNT").where(QueryColumn.column(COLUMN_PLAYER_ID, playerId), QueryColumn.column(COLUMN_NAME, name), QueryColumn.column(COLUMN_CLOSED, false)).getSingle(this::getFromResultRow);
    }

    public Optional<BankAccount> getPlayersBankAccountByType(int playerId, BankAccountType bankAccountType) {
        return Query.selectAllFrom("BANK_ACCOUNT").where(QueryColumn.column(COLUMN_PLAYER_ID, playerId), QueryColumn.column(COLUMN_ACCOUNT_TYPE, bankAccountType)).getSingle(this::getFromResultRow);
    }

    public Optional<BankAccount> getBankAccountById(int accountId) {
        return Query.selectAllFrom("BANK_ACCOUNT").where(QueryColumn.column(COLUMN_ID, accountId)).getSingle(this::getFromResultRow);
    }

    public List<BankAccount> getAllPlayersBankAccounts(int playerId) {
        return Query.selectAllFrom("BANK_ACCOUNT").where(QueryColumn.column(COLUMN_PLAYER_ID, playerId), QueryColumn.column(COLUMN_CLOSED, false)).getList(this::getFromResultRow);
    }

    private BankAccount getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        BankAccountType bankAccountType = row.getEnum(COLUMN_ACCOUNT_TYPE, BankAccountType.class);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        double balance = row.getDouble(COLUMN_BALANCE);
        boolean closed = row.getBoolean(COLUMN_CLOSED);
        return new BankAccount(id, name, bankAccountType, playerId, balance, closed);
    }
}

