/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy.account;

import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.account.AccountNameAlreadyUsedException;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountHoldingEntity;
import com.equestricraft.core.economy.account.BankAccountInfo;
import com.equestricraft.core.economy.account.CannotCloseAccountException;
import com.equestricraft.core.economy.account.CannotUpdateAccountException;
import com.equestricraft.core.economy.account.NoBankAccountException;
import com.equestricraft.core.economy.account.PlayerAlreadyHasAccountException;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;

public interface BankAccountSession {
    public BankAccount createMainAccount(ECPlayer var1) throws PlayerAlreadyHasAccountException;

    public BankAccount createSavingsAccount(ECPlayer var1, String var2) throws AccountNameAlreadyUsedException;

    public BankAccount createExternalAccount(ECPlayer var1, String var2) throws AccountNameAlreadyUsedException;

    public BankAccount getPlayersMainAccount(ECPlayer var1);

    public BankAccount getAccountById(int var1);

    public BankAccount getEntitiesAccount(BankAccountHoldingEntity var1) throws NoBankAccountException;

    public void renameAccount(BankAccount var1, String var2) throws EconomyException;

    public void updateAccountsBalance(BankAccount var1, double var2);

    public void transferAccountOwnership(BankAccount var1, ECPlayer var2) throws CannotUpdateAccountException;

    public void clearAccountToOwnersMain(BankAccount var1) throws EconomyException;

    public void closeAccount(BankAccount var1) throws CannotCloseAccountException;

    public List<BankAccountInfo> getAllPlayersBankAccounts(ECPlayer var1);
}

