/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy.account;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.BankAccountType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.Economy;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.account.AccountNameAlreadyUsedException;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountDatabase;
import com.equestricraft.core.economy.account.BankAccountHoldingEntity;
import com.equestricraft.core.economy.account.BankAccountInfo;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.economy.account.CannotCloseAccountException;
import com.equestricraft.core.economy.account.CannotUpdateAccountException;
import com.equestricraft.core.economy.account.NoBankAccountException;
import com.equestricraft.core.economy.account.PlayerAlreadyHasAccountException;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;
import java.util.List;
import java.util.Optional;

public class BankAccountSessionImpl
implements BankAccountSession {
    @Service
    private BankAccountDatabase bankAccountDatabase;
    @Service
    private Economy economy;
    private static final Log log = Log.getLogger(BankAccountSessionImpl.class.getName());

    @Override
    public BankAccount createMainAccount(ECPlayer player) throws PlayerAlreadyHasAccountException {
        this.ensurePlayerDoesNotHaveMainAccount(player);
        return this.createNewBankAccount("Main", BankAccountType.MAIN, player);
    }

    @Override
    public BankAccount createSavingsAccount(ECPlayer player, String name) throws AccountNameAlreadyUsedException {
        this.ensureAccountNameNotAlreadyUsed(player.getId(), name);
        this.ensureAccountNameCharacterLimit(name);
        return this.createNewBankAccount(name, BankAccountType.SAVINGS, player);
    }

    @Override
    public BankAccount createExternalAccount(ECPlayer player, String name) throws AccountNameAlreadyUsedException {
        this.ensureAccountNameNotAlreadyUsed(player.getId(), name);
        this.ensureAccountNameCharacterLimit(name);
        return this.createNewBankAccount(name, BankAccountType.EXTERNAL, player);
    }

    private void ensurePlayerDoesNotHaveMainAccount(ECPlayer player) throws PlayerAlreadyHasAccountException {
        Optional<BankAccount> mainAccounts = this.bankAccountDatabase.getPlayersBankAccountByType(player.getId(), BankAccountType.MAIN);
        if (mainAccounts.isPresent()) {
            throw new PlayerAlreadyHasAccountException(String.format("Player %s already has a main bank account", player.getIgn()));
        }
    }

    private void ensureAccountNameNotAlreadyUsed(int playerId, String name) throws AccountNameAlreadyUsedException {
        if (this.bankAccountDatabase.getOpenBankAccountByPlayerAndName(playerId, name).isPresent()) {
            throw new AccountNameAlreadyUsedException(I18n.getLabel("economy.bank-account.name-already-used", name));
        }
    }

    private BankAccount createNewBankAccount(String accountName, BankAccountType type, ECPlayer player) {
        BankAccount bankAccount = new BankAccount(0, accountName, type, player.getId(), 0.0, false);
        this.bankAccountDatabase.addBankAccount(bankAccount);
        log.info("Created {} bank account for player {}. Account ID: {}", type.name(), player.getIgn(), bankAccount.getId());
        return bankAccount;
    }

    @Override
    public BankAccount getPlayersMainAccount(ECPlayer player) {
        return this.getPlayersMainAccount(player.getId());
    }

    private BankAccount getPlayersMainAccount(int playerId) {
        Optional<BankAccount> account = this.bankAccountDatabase.getPlayersBankAccountByType(playerId, BankAccountType.MAIN);
        return account.orElseThrow();
    }

    @Override
    public BankAccount getAccountById(int accountId) {
        return this.bankAccountDatabase.getBankAccountById(accountId).orElseThrow();
    }

    @Override
    public BankAccount getEntitiesAccount(BankAccountHoldingEntity bankAccountHoldingEntity) throws NoBankAccountException {
        return this.getAccountById(bankAccountHoldingEntity.requireBankAccountId());
    }

    @Override
    public void renameAccount(BankAccount bankAccount, String newName) throws EconomyException {
        if (!bankAccount.getBankAccountType().isAllowRename()) {
            throw new CannotUpdateAccountException(I18n.getLabel("economy.cannot-rename-account"));
        }
        this.ensureAccountNameCharacterLimit(newName);
        this.ensureAccountNameNotAlreadyUsed(bankAccount.getPlayerId(), newName);
        this.bankAccountDatabase.updateAccountName(bankAccount.getId(), newName);
        bankAccount.setName(newName);
    }

    @Override
    public void updateAccountsBalance(BankAccount bankAccount, double newBalance) {
        this.bankAccountDatabase.updateAccountBalance(bankAccount.getId(), newBalance);
        bankAccount.setBalance(newBalance);
    }

    @Override
    public void transferAccountOwnership(BankAccount bankAccount, ECPlayer newOwner) throws CannotUpdateAccountException {
        if (!bankAccount.getBankAccountType().isAllowTransfer()) {
            throw new CannotUpdateAccountException(I18n.getLabel("economy.cannot-transfer-account"));
        }
        this.bankAccountDatabase.updateAccountOwner(bankAccount.getId(), newOwner.getId());
        bankAccount.setPlayerId(newOwner.getId());
    }

    @Override
    public void clearAccountToOwnersMain(BankAccount bankAccount) throws EconomyException {
        if (bankAccount.getBankAccountType() == BankAccountType.MAIN) {
            throw new IllegalArgumentException("Cannot move main account contents to main account");
        }
        BankAccount mainAccount = this.getPlayersMainAccount(bankAccount.getPlayerId());
        this.economy.transfer(bankAccount, mainAccount, bankAccount.getBalance(), I18n.getLabel("economy.account-clear-to-main.reason"));
    }

    @Override
    public void closeAccount(BankAccount bankAccount) throws CannotCloseAccountException {
        if (!bankAccount.getBankAccountType().isAllowClose()) {
            throw new CannotCloseAccountException(I18n.getLabel("economy.cannot-close-account.type"));
        }
        if (bankAccount.getBalance() != 0.0) {
            throw new CannotCloseAccountException(I18n.getLabel("economy.cannot-close-account.not-empty"));
        }
        this.bankAccountDatabase.updateAccountClosed(bankAccount.getId(), true);
        bankAccount.setClosed(true);
    }

    @Override
    public List<BankAccountInfo> getAllPlayersBankAccounts(ECPlayer player) {
        List<BankAccount> accounts = this.bankAccountDatabase.getAllPlayersBankAccounts(player.getId());
        return accounts.stream().map(this::buildInfo).toList();
    }

    private BankAccountInfo buildInfo(BankAccount a) {
        return new BankAccountInfo(a.getId(), a.getName(), a.getBankAccountType(), a.getBalance(), EconomyUtilities.formatCurrency(a.getBalance()));
    }

    private void ensureAccountNameCharacterLimit(String name) {
        if (name.length() > 120) {
            throw new IllegalArgumentException(I18n.getLabel("economy.account-name-character-limit", 120));
        }
    }
}

