/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy.transaction;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.economy.transaction.BankAccountTransaction;
import java.util.Date;
import java.util.List;

public class BankAccountTransactionDatabase {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_BANK_ACCOUNT_ID = "BANK_ACCOUNT_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_AMOUNT = "AMOUNT";
    private static final String COLUMN_OTHER_PLAYER_ID = "OTHER_PLAYER_ID";
    private static final String COLUMN_OTHER_BANK_ACCOUNT_ID = "OTHER_BANK_ACCOUNT_ID";
    private static final String COLUMN_REASON = "REASON";
    private static final String COLUMN_SOURCE_DESCRIPTION = "SOURCE_DESCRIPTION";

    public void addTransaction(BankAccountTransaction bankAccountTransaction) {
        Query.insertInto("BANK_ACCOUNT_TRANSACTION").columns(QueryColumn.column(COLUMN_PLAYER_ID, bankAccountTransaction.getPlayerId()), QueryColumn.column(COLUMN_BANK_ACCOUNT_ID, bankAccountTransaction.getBankAccountId()), QueryColumn.column(COLUMN_TIME_STAMP, bankAccountTransaction.getTime()), QueryColumn.column(COLUMN_AMOUNT, bankAccountTransaction.getAmount()), QueryColumn.column(COLUMN_OTHER_PLAYER_ID, bankAccountTransaction.getOtherPlayerId()), QueryColumn.column(COLUMN_OTHER_BANK_ACCOUNT_ID, bankAccountTransaction.getOtherBankAccountId()), QueryColumn.column(COLUMN_REASON, bankAccountTransaction.getReason()), QueryColumn.column(COLUMN_SOURCE_DESCRIPTION, bankAccountTransaction.getSourceDescription())).executeGetGeneratedKey(bankAccountTransaction::setId);
    }

    public List<BankAccountTransaction> getAllPlayersTransactions(int playerId) {
        return Query.selectAllFrom("BANK_ACCOUNT_TRANSACTION").where(QueryColumn.column(String.format("t.%s", COLUMN_PLAYER_ID), playerId)).getList(this::getFromResultRow);
    }

    public List<BankAccountTransaction> getAllAccountsTransactions(int accountId) {
        return Query.selectAllFrom("BANK_ACCOUNT_TRANSACTION").where(QueryColumn.column(COLUMN_BANK_ACCOUNT_ID, accountId)).getList(this::getFromResultRow);
    }

    private BankAccountTransaction getFromResultRow(ResultRow row) {
        Integer id = row.getInt(COLUMN_ID);
        Integer playerId = row.getInt(COLUMN_PLAYER_ID);
        Integer bankAccountId = row.getInt(COLUMN_BANK_ACCOUNT_ID);
        Date time = new Date(row.getLong(COLUMN_TIME_STAMP));
        Double amount = row.getDouble(COLUMN_AMOUNT);
        Integer otherPlayerId = row.getNullableInt(COLUMN_OTHER_PLAYER_ID);
        Integer otherBankAccountId = row.getNullableInt(COLUMN_OTHER_BANK_ACCOUNT_ID);
        String reason = row.getString(COLUMN_REASON);
        String sourceDescription = row.getNullableString(COLUMN_SOURCE_DESCRIPTION);
        return new BankAccountTransaction(id, playerId, bankAccountId, time, amount, otherPlayerId, otherBankAccountId, reason, sourceDescription);
    }
}

