/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.economy.transaction;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ObjectUtils;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.economy.transaction.BankAccountTransaction;
import com.equestricraft.core.economy.transaction.BankAccountTransactionDatabase;
import com.equestricraft.core.economy.transaction.BankAccountTransactionInfo;
import com.equestricraft.core.economy.transaction.BankAccountTransactionSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BankAccountTransactionSessionImpl
implements BankAccountTransactionSession {
    @Service
    private BankAccountTransactionDatabase bankAccountTransactionDatabase;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private BankAccountSession bankAccountSession;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public void addTransaction(BankAccount account, Date time, double amount, String reason, String sourceDescription) {
        this.addTransaction(account, time, amount, reason, null, sourceDescription);
    }

    @Override
    public void addTransaction(BankAccount account, Date time, double amount, String reason, BankAccount otherAccount, String sourceDescription) {
        Objects.requireNonNull(account, "Must provide a bank account the transaction is for");
        Objects.requireNonNull(time, "Must provide a time for the transaction");
        Objects.requireNonNull(reason, "Must provide a reason for the transaction");
        Integer otherPlayerId = null;
        Integer otherAccountId = null;
        if (otherAccount != null) {
            otherPlayerId = otherAccount.getPlayerId();
            otherAccountId = otherAccount.getId();
        }
        BankAccountTransaction transaction = new BankAccountTransaction(0, account.getPlayerId(), account.getId(), time, amount, otherPlayerId, otherAccountId, reason, sourceDescription);
        this.bankAccountTransactionDatabase.addTransaction(transaction);
    }

    @Override
    public List<BankAccountTransactionInfo> getAllPlayersTransactions(ECPlayer player) {
        List<BankAccountTransaction> transactions = this.bankAccountTransactionDatabase.getAllPlayersTransactions(player.getId());
        return transactions.stream().map(this::buildInfo).toList();
    }

    @Override
    public List<BankAccountTransactionInfo> getAllAccountsTransactions(int accountId) {
        List<BankAccountTransaction> transactions = this.bankAccountTransactionDatabase.getAllAccountsTransactions(accountId);
        return transactions.stream().map(this::buildInfo).toList();
    }

    private BankAccountTransactionInfo buildInfo(BankAccountTransaction bankAccountTransaction) {
        CorePlayer otherPlayer = bankAccountTransaction.getOtherPlayerId() != null ? (CorePlayer)this.playerRepository.findByKey(bankAccountTransaction.getOtherPlayerId()) : null;
        BankAccount otherAccount = bankAccountTransaction.getOtherBankAccountId() != null ? this.bankAccountSession.getAccountById(bankAccountTransaction.getOtherBankAccountId()) : null;
        return new BankAccountTransactionInfo(bankAccountTransaction.getId(), bankAccountTransaction.getTime().getTime(), bankAccountTransaction.getAmount(), EconomyUtilities.formatCurrency(bankAccountTransaction.getAmount()), ObjectUtils.nullable(otherPlayer, this.playerTransformer::toSimple), ObjectUtils.nullable(otherAccount, BankAccount::getId), ObjectUtils.nullable(otherAccount, BankAccount::getName), bankAccountTransaction.getReason());
    }
}

