/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.entityload;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.EntityLoadMessage;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.core.entityload.EntityLoader;
import com.equestricraft.logging.Log;
import com.equestricraft.redis.RedisChannelSubscription;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EntityLoadController {
    private static final EntityLoadController instance = EntityLoadController.createInstance();
    private static final RedisChannelSubscription<EntityLoadMessage> entityLoadChannel = new RedisChannelSubscription("entity_load");
    private final Map<String, ? extends EntityLoader> entityLoaderMap;
    private static final Log log = Log.getLogger(EntityLoadController.class.getName());

    public static void initEntityLoader() {
        entityLoadChannel.subscribe(instance::handlePacket);
    }

    private void handlePacket(EntityLoadMessage message) {
        this.load(message.getModule(), message.getKey());
    }

    private static EntityLoadController createInstance() {
        List<Class<EntityLoader>> loaders = ReflectionHelper.scanClassesImplementingType(EntityLoader.class);
        Map map = loaders.stream().map(Services::getService).collect(Collectors.toUnmodifiableMap(EntityLoader::name, Function.identity()));
        return new EntityLoadController(map);
    }

    public static EntityLoadController getInstance() {
        return instance;
    }

    private EntityLoadController(Map<String, ? extends EntityLoader> entityLoaderMap) {
        this.entityLoaderMap = entityLoaderMap;
    }

    public void load(String module, String key) {
        EntityLoader loader = this.entityLoaderMap.get(module);
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Entity loader %s not found", module));
        }
        try {
            log.info("Loading entity {} for module {}", (Object)key, (Object)module);
            loader.load(key);
        }
        catch (Exception ex) {
            log.error("Error loading entity", ex);
        }
    }
}

