/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.errorlog;

import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.core.errorlog.ErrorLog;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ErrorLogDatabase {
    public void addErrorLog(ErrorLog log) {
        Query.insertInto("ERROR_LOG").columns(QueryColumn.column("CONTAINER", log.getContainer()), QueryColumn.column("MESSAGE", log.getMessage()), QueryColumn.column("TIME_STAMP", log.getTimeStamp()), QueryColumn.column("SEVERITY", log.getSeverity()), QueryColumn.column("STACK_TRACE", log.getStackTrace())).execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getErrorLogCount() {
        try (PreparedStatement statement = Query.prepare(String.format("SELECT COUNT(*) FROM %s", "ERROR_LOG"));){
            ResultSet set2 = statement.executeQuery();
            if (set2.next()) {
                int n2 = set2.getInt(1);
                return n2;
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }
}

