/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.errorlog;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ApplicationConstants;
import com.equestricraft.common.Severity;
import com.equestricraft.core.errorlog.ErrorLog;
import com.equestricraft.core.errorlog.ErrorLogDatabase;
import com.equestricraft.core.errorlog.ErrorLogService;
import com.equestricraft.redis.RedisEventBus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ErrorLogServiceImpl
implements ErrorLogService {
    @Service
    private ErrorLogDatabase errorLogDatabase;
    private final RedisEventBus redisEventBus = RedisEventBus.getInstance();
    private final BlockingQueue<ErrorLog> queue = new LinkedBlockingQueue<ErrorLog>();

    @Override
    public void logError(String message, Severity severity) {
        this.logError(message, severity, null);
    }

    @Override
    public void logError(String message, Severity severity, Throwable throwable) {
        String stackTrace = this.buildStackTraceString(throwable);
        ErrorLog errorLog = new ErrorLog("Forge Mod", message, new Date(), severity, stackTrace);
        this.queue.add(errorLog);
    }

    private String buildStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    @Override
    public void processQueue() {
        ArrayList toPersist = new ArrayList();
        int amountTransferred = this.queue.drainTo(toPersist);
        if (amountTransferred > 0) {
            for (ErrorLog errorLog : toPersist) {
                int count = this.errorLogDatabase.getErrorLogCount();
                if (count >= ApplicationConstants.MAXIMUM_ERROR_LOG_COUNT) continue;
                this.errorLogDatabase.addErrorLog(errorLog);
            }
            this.redisEventBus.postEvent("error_posted");
        }
    }
}

