/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.errorlog;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.Severity;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.errorlog.ErrorLogService;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.logging.Log;
import com.equestricraft.logging.LogLevel;
import java.util.Timer;
import java.util.TimerTask;

public class ErrorLogSystem
implements SubSystem {
    @Service
    private ErrorLogService errorLogService;
    private final Timer timer = new Timer(ThreadUtils.threadName("error-log-processor"));

    @Override
    public void onEnable() {
        Log.registerListener(logEntry -> this.errorLogService.logError(logEntry.message(), this.transformLogLevel(logEntry.level()), logEntry.throwable()), LogLevel.ERROR, LogLevel.WARN);
        long period = this.getProcessPeriod();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ErrorLogSystem.this.errorLogService.processQueue();
            }
        };
        this.timer.schedule(task, period, period);
    }

    private Severity transformLogLevel(LogLevel level) {
        return switch (level) {
            case LogLevel.WARN -> Severity.WARNING;
            case LogLevel.ERROR -> Severity.ERROR;
            default -> throw new IllegalArgumentException(String.format("Invalid log level: %s", level.name()));
        };
    }

    private long getProcessPeriod() {
        String interval = System.getenv("EC_ERROR_LOG_PROCESS_INTERVAL");
        try {
            return 1000L * (long)Integer.parseInt(interval);
        }
        catch (Exception ex) {
            return 5000L;
        }
    }

    @Override
    public void onDisable() {
        this.timer.cancel();
        this.errorLogService.processQueue();
    }
}

