/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.faction;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.common.Argb;
import com.equestricraft.core.faction.FactionRank;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Faction
implements RepositoryEntity<Integer> {
    private final int id;
    private String name;
    private String identifier;
    private String description;
    private String chatTag;
    private Argb color;
    private String welcomeMessage;
    private List<FactionRank> factionRanks;

    public Faction(int id, String name, String identifier, String description, String chatTag, Argb color, String welcomeMessage) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.description = description;
        this.chatTag = chatTag;
        this.color = color;
        this.welcomeMessage = welcomeMessage;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public String getChatTag() {
        return this.chatTag;
    }

    protected void setChatTag(String chatTag) {
        this.chatTag = chatTag;
    }

    public Argb getColor() {
        return this.color;
    }

    protected void setColor(Argb color) {
        this.color = color;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    protected void setWelcomeMessage(String welcomeMessage) {
        this.welcomeMessage = welcomeMessage;
    }

    public List<FactionRank> getFactionRanks() {
        return this.factionRanks;
    }

    protected void setFactionRanks(List<FactionRank> factionRanks) {
        this.factionRanks = factionRanks;
    }

    public FactionRank getRankForXp(int xp) {
        ArrayList<FactionRank> ranks = new ArrayList<FactionRank>(this.getFactionRanks());
        Collections.reverse(ranks);
        for (FactionRank rank : ranks) {
            if (rank.getXpThreshold() > xp) continue;
            return rank;
        }
        throw new IllegalArgumentException(String.format("Could not find a rank in faction %s for %sxp", this.getName(), xp));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Faction faction = (Faction)o;
        return this.id == faction.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

