/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.faction;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.Argb;
import com.equestricraft.core.faction.Faction;
import com.equestricraft.core.faction.FactionRank;
import java.util.List;

public class FactionDatabase
implements RepositoryDatasource<Faction, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_CHAT_TAG = "CHAT_TAG";
    private static final String COLUMN_COLOR = "COLOR";
    private static final String COLUMN_WELCOME_MESSAGE = "WELCOME_MESSAGE";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";
    private static final String COLUMN_FACTION_ID = "FACTION_ID";
    private static final String COLUMN_XP_THRESHOLD = "XP_THRESHOLD";

    @Override
    public List<Faction> retrieveAll() {
        return Query.selectAllFrom("FACTION").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getFromResultRow);
    }

    private Faction getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        String chatTag = row.getString(COLUMN_CHAT_TAG);
        Argb color = row.getArgbColor(COLUMN_COLOR);
        String welcomeMessage = row.getString(COLUMN_WELCOME_MESSAGE);
        Faction faction = new Faction(id, name, identifier, description, chatTag, color, welcomeMessage);
        List<FactionRank> ranks = this.getOrderedRanksForFaction(faction);
        faction.setFactionRanks(ranks);
        return faction;
    }

    private List<FactionRank> getOrderedRanksForFaction(Faction faction) {
        return Query.selectAllFrom("FACTION_RANK").where(QueryColumn.column(COLUMN_FACTION_ID, faction.getId())).orderBy("XP_THRESHOLD ASC").getList(r -> this.getFactionRankFromResultRow(r, faction));
    }

    private FactionRank getFactionRankFromResultRow(ResultRow row, Faction faction) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        int xpThreshold = row.getInt(COLUMN_XP_THRESHOLD);
        FactionRank rank = new FactionRank(id, name, description, xpThreshold);
        rank.setFaction(faction);
        return rank;
    }
}

