/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.faction;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositoryUpdatePolicy;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.faction.Faction;
import com.equestricraft.core.faction.FactionDatabase;
import java.util.Optional;
import java.util.function.Function;

public class FactionRepository
extends Repository<Faction, Integer> {
    @Service
    private FactionDatabase factionDatabase;

    @Override
    protected RepositoryDatasource<Faction, Integer> getDatasource() {
        return this.factionDatabase;
    }

    @Override
    protected RepositoryUpdatePolicy updatePolicy() {
        return RepositoryUpdatePolicy.UPDATE;
    }

    @Override
    protected void onEntityUpdate(Faction existingEntity, Faction newEntity) {
        existingEntity.setName(newEntity.getName());
        existingEntity.setIdentifier(newEntity.getIdentifier());
        existingEntity.setDescription(newEntity.getDescription());
        existingEntity.setChatTag(newEntity.getChatTag());
        existingEntity.setColor(newEntity.getColor());
        existingEntity.setWelcomeMessage(newEntity.getWelcomeMessage());
        existingEntity.setFactionRanks(newEntity.getFactionRanks());
    }

    @Override
    protected Function<Faction, Object> getIndexFunction() {
        return Faction::getIdentifier;
    }

    public Optional<Faction> findByIdentifier(String identifier) {
        return this.findByIndexKeyIfExists(identifier);
    }
}

