/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.fasttravel;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.fasttravel.FastTravelSession;
import com.equestricraft.core.fasttravel.point.FastTravelPoint;
import com.equestricraft.core.fasttravel.point.FastTravelPointRepository;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;
import java.util.function.Predicate;

public class FastTravelSessionImpl
implements FastTravelSession {
    @Service
    private FastTravelPointRepository fastTravelPointRepository;

    @Override
    public List<FastTravelPoint> retrieveAvailablePointsForPlayer(ECPlayer player, FastTravelPoint currentPoint) {
        List<FastTravelPoint> pointsInGroup = this.fastTravelPointRepository.findByGroup(currentPoint.getGroupId());
        return pointsInGroup.stream().filter(Predicate.not(currentPoint::equals)).filter(p -> {
            if (p.getRequiredDiscoverLocationId() == null) {
                return true;
            }
            return player.getDiscoverLocations().hasPlayerFoundLocation(p.getRequiredDiscoverLocationId());
        }).toList();
    }
}

