/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.fasttravel.point;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.fasttravel.point.FastTravelPoint;
import java.util.List;

public class FastTravelPointDatabase
implements RepositoryDatasource<FastTravelPoint, Integer> {
    @Override
    public List<FastTravelPoint> retrieveAll() {
        return Query.selectAllFrom("FAST_TRAVEL_POINT").where(QueryColumn.column("ENABLED", true)).getList(this::getPointFromResultRow);
    }

    private FastTravelPoint getPointFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        DirectionalCoordinate location = row.getDirectionalCoordinate("LOCATION");
        int groupId = row.getInt("GROUP_ID");
        int npcId = row.getInt("NPC_ID");
        Integer requiredDiscoverLocationId = row.getNullableInt("REQUIRED_DISCOVER_LOCATION_ID");
        return new FastTravelPoint(id, name, location, groupId, npcId, requiredDiscoverLocationId);
    }
}

