/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.featureflag;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.featureflag.FeatureFlagDataSource;
import com.equestricraft.featureflag.FeatureFlagRecord;
import java.util.List;

public class FeatureFlagDatabase
implements FeatureFlagDataSource {
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_STATE = "STATE";

    @Override
    public List<FeatureFlagRecord> getAllFeatureFlags() {
        return Query.selectAllFrom("FEATURE_FLAG").getList(this::getFromResultRow);
    }

    private FeatureFlagRecord getFromResultRow(ResultRow row) {
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        boolean state = row.getBoolean(COLUMN_STATE);
        return new FeatureFlagRecord(identifier, name, description, state);
    }

    @Override
    public void updateFlag(FeatureFlag flag) {
        Query.insertInto("FEATURE_FLAG").columns(QueryColumn.column(COLUMN_IDENTIFIER, flag.name()), QueryColumn.column(COLUMN_NAME, flag.getName()), QueryColumn.column(COLUMN_DESCRIPTION, flag.getDescription()), QueryColumn.column(COLUMN_STATE, flag.isEnabled())).onDuplicateKeyUpdate("NAME = VALUES(NAME)", "DESCRIPTION = VALUES(DESCRIPTION)").execute();
    }

    @Override
    public void deleteFlag(String flag) {
        Query.deleteFrom("FEATURE_FLAG").where(QueryColumn.column(COLUMN_IDENTIFIER, flag)).execute();
    }
}

