/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.gameannouncement;

import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.gameannouncement.GameAnnouncementService;
import com.equestricraft.core.gameannouncement.GameAnnouncementSettings;
import com.equestricraft.core.repeatingtask.RepeatingTask;
import com.equestricraft.core.repeatingtask.RepeatingTaskManager;
import com.equestricraft.core.setting.ECPostSettingsLoadEvent;
import java.time.Duration;

public class GameAnnouncementTask
extends RepeatingTask {
    @Service
    private GameAnnouncementService gameAnnouncementService;
    private static final String TASK_NAME = "Game Announcements";

    @Override
    public String name() {
        return TASK_NAME;
    }

    @Override
    public void execute() {
        this.gameAnnouncementService.makeAnnouncement();
    }

    @Override
    public Duration delay() {
        return Duration.ofSeconds(GameAnnouncementSettings.getIntervalSeconds().intValue());
    }

    @Override
    public Duration period() {
        return Duration.ofSeconds(GameAnnouncementSettings.getIntervalSeconds().intValue());
    }

    @ECEventBusListener
    public static void onSettingsLoad(ECPostSettingsLoadEvent event) {
        if (event.getKeys().contains("game-announcement.interval.seconds")) {
            RepeatingTaskManager.getInstance().restartTask(TASK_NAME);
        }
    }
}

