/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse;

import com.equestricraft.api.common.APIAlleleDto;
import com.equestricraft.api.common.APIHorseCreateRequestDto;
import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.groovy.APIHorseService;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.Dominance;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.HorseOrigin;
import com.equestricraft.core.allele.AlleleConfig;
import com.equestricraft.core.allele.AlleleTransformer;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.create.HorseCreateRequest;
import com.equestricraft.core.horse.create.HorseCreateService;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Map;
import java.util.Objects;

public class APIHorseServiceImpl
implements APIHorseService {
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseCreateService horseCreateService;
    @Service
    private PlayerTransformer playerTransformer;
    @Service
    private AlleleTransformer alleleTransformer;

    @Override
    public APIHorseDto createHorse(APIHorseCreateRequestDto createRequest) {
        Objects.requireNonNull(createRequest);
        Objects.requireNonNull(createRequest.getOwner(), "Must supply an owner");
        Objects.requireNonNull(createRequest.getName(), "Must supply a name");
        Objects.requireNonNull(createRequest.getGender(), "Must supply a gender");
        CorePlayer owner = this.playerTransformer.fromDto(createRequest.getOwner());
        String name = createRequest.getName();
        HorseGender horseGender = HorseGender.valueOf(createRequest.getGender());
        int ageMonths = createRequest.getAgeMonths() != null ? createRequest.getAgeMonths() : 0;
        boolean bypassHorseLimit = createRequest.isBypassHorseLimit();
        Double finalWeight = createRequest.getFinalWeight();
        Double finalHeight = createRequest.getFinalHeight();
        HorseCreateRequest.Builder builder = HorseCreateRequest.Builder.start().withOrigin(HorseOrigin.CUSTOM).withName(name).withOwner(owner).withGender(horseGender).withAgeMonths(ageMonths).withBypassHorseLimit(bypassHorseLimit).withFinalWeight(finalWeight).withFinalHeight(finalHeight);
        if (createRequest.getCurrentValue() != null) {
            builder.withCurrentValue(createRequest.getCurrentValue());
        }
        if (createRequest.getMother() != null && createRequest.getFather() != null) {
            builder.withParents(createRequest.getMother().getId(), createRequest.getFather().getId());
        }
        for (Map.Entry<APIAlleleDto, String> allele : createRequest.getAlleleDominanceMap().entrySet()) {
            AlleleConfig a = this.alleleTransformer.fromDto(allele.getKey());
            builder.withAllele(a.getIdentifier(), Dominance.valueOf(allele.getValue()));
        }
        if (createRequest.getColor() != null) {
            HorseCoatDetails coatDetails = HorseCoatDetails.Builder.start().withColor(HorseCoatColor.valueOf(createRequest.getColor())).withMarkings(createRequest.getMarkings().stream().map(HorseCoatMarking::valueOf).toList()).withGrayScale(createRequest.isGray() ? 1.0f : 0.0f).complete();
            builder.withCoatDetails(coatDetails);
        }
        builder.withTrustLevel(createRequest.getOwnerTrustLevel());
        builder.withOwnedByPlayer(createRequest.isOwnedByPlayer());
        HorseCreateRequest horseCreateRequest = builder.complete();
        EQHorse horse = this.horseCreateService.createHorse(horseCreateRequest);
        return new APIHorseDtoImpl(horse);
    }

    @Override
    public APIHorseDto getHorseById(int id) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(id);
        return new APIHorseDtoImpl(horse);
    }
}

