/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.action.HorseActionAccessor;
import com.equestricraft.core.horse.age.HorseAgeAccessor;
import com.equestricraft.core.horse.appetite.HorseAppetiteAccessor;
import com.equestricraft.core.horse.attribute.HorseAttributesAccessor;
import com.equestricraft.core.horse.bit.HorseBitAccessor;
import com.equestricraft.core.horse.blood.HorseBloodAccessor;
import com.equestricraft.core.horse.breed.BreedEntity;
import com.equestricraft.core.horse.breed.HorseBreedAccessor;
import com.equestricraft.core.horse.breeding.HorseBreedingAccessor;
import com.equestricraft.core.horse.care.HorseCareAccessor;
import com.equestricraft.core.horse.coat.HorseCoatAccessor;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.command.HorseCommandExecutor;
import com.equestricraft.core.horse.conformation.HorseConformationAccessor;
import com.equestricraft.core.horse.death.HorseDeathAccessor;
import com.equestricraft.core.horse.discipline.HorseDisciplineAccessor;
import com.equestricraft.core.horse.energy.HorseEnergyAccessor;
import com.equestricraft.core.horse.environment.HorseEnvironmentAccessor;
import com.equestricraft.core.horse.fertility.HorseFertilityAccessor;
import com.equestricraft.core.horse.frustration.HorseFrustrationAccessor;
import com.equestricraft.core.horse.gait.HorseGaitAccessor;
import com.equestricraft.core.horse.genetic.HorseGeneticAccessor;
import com.equestricraft.core.horse.handling.HorseHandlingAccessor;
import com.equestricraft.core.horse.health.HorseHealthAccessor;
import com.equestricraft.core.horse.heart.HorseHeartAccessor;
import com.equestricraft.core.horse.height.HorseHeightAccessor;
import com.equestricraft.core.horse.hoof.HorseHoovesAccessor;
import com.equestricraft.core.horse.horselog.HorseLogAccessor;
import com.equestricraft.core.horse.illness.HorseIllnessAccessor;
import com.equestricraft.core.horse.instruction.HorseInstructionAccessor;
import com.equestricraft.core.horse.intelligence.HorseIntelligenceAccessor;
import com.equestricraft.core.horse.jump.HorseJumpAccessor;
import com.equestricraft.core.horse.lineage.HorseLineageAccessor;
import com.equestricraft.core.horse.location.HorseLocationAccessor;
import com.equestricraft.core.horse.medicine.HorseMedicineAccessor;
import com.equestricraft.core.horse.memory.HorseMemoryAccessor;
import com.equestricraft.core.horse.metabolism.HorseMetabolismAccessor;
import com.equestricraft.core.horse.microchip.HorseMicrochipAccessor;
import com.equestricraft.core.horse.movement.HorseMovementAccessor;
import com.equestricraft.core.horse.nutrient.HorseNutritionAccessor;
import com.equestricraft.core.horse.obedience.HorseObedienceAccessor;
import com.equestricraft.core.horse.operation.HorseOperationAccessor;
import com.equestricraft.core.horse.pregnancy.HorsePregnancyAccessor;
import com.equestricraft.core.horse.prescription.HorsePrescriptionAccessor;
import com.equestricraft.core.horse.progression.HorseProgressionAccessor;
import com.equestricraft.core.horse.provision.HorseProvisionAccessor;
import com.equestricraft.core.horse.registration.HorseRegistrationAccessor;
import com.equestricraft.core.horse.relationship.HorseRelationshipAccessor;
import com.equestricraft.core.horse.ride.HorseCurrentRideAccessor;
import com.equestricraft.core.horse.ridelog.HorseRideTimeAccessor;
import com.equestricraft.core.horse.shoe.HorseShoeAccessor;
import com.equestricraft.core.horse.skill.HorseSkillAccessor;
import com.equestricraft.core.horse.spay.HorseSpayAccessor;
import com.equestricraft.core.horse.speed.HorseSpeedAccessor;
import com.equestricraft.core.horse.stallrest.HorseStallRestAccessor;
import com.equestricraft.core.horse.stamina.HorseStaminaAccessor;
import com.equestricraft.core.horse.status.HorseStatusAccessor;
import com.equestricraft.core.horse.stress.HorseStressAccessor;
import com.equestricraft.core.horse.stud.HorseStudRegistrationAccessor;
import com.equestricraft.core.horse.symptom.HorseSymptomAccessor;
import com.equestricraft.core.horse.tack.HorseTackAccessor;
import com.equestricraft.core.horse.tag.HorseTagsAccessor;
import com.equestricraft.core.horse.trait.HorseTraitAccessor;
import com.equestricraft.core.horse.trust.HorseTrustAccessor;
import com.equestricraft.core.horse.warmup.HorseWarmUpAccessor;
import com.equestricraft.core.horse.weight.HorseWeightAccessor;
import com.equestricraft.core.horse.wormer.HorseWormerAccessor;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.tick.ActiveTickable;
import com.equestricraft.logging.Log;
import java.util.ArrayList;
import java.util.List;

public abstract class HorseAdapter
implements ActiveTickable,
BreedEntity {
    private static final PlayerRepository playerRepository = Services.getService(PlayerRepository.class);
    private static final HorseRepository horseRepository = Services.getService(HorseRepository.class);
    private final List<ActiveTickable> activeTickables = new ArrayList<ActiveTickable>();
    private final List<AbstractHorseAccessor> accessors = new ArrayList<AbstractHorseAccessor>();
    private final HorseCommandExecutor commandExecutor = new HorseCommandExecutor(this.getEqHorse());
    private final HorseAgeAccessor age = new HorseAgeAccessor(this.getEqHorse());
    private final HorseAttributesAccessor attributes = new HorseAttributesAccessor(this.getEqHorse());
    private final HorseSpeedAccessor speed = new HorseSpeedAccessor(this.getEqHorse());
    private final HorseTackAccessor tacks = new HorseTackAccessor(this.getEqHorse());
    private final HorseGeneticAccessor genetics = new HorseGeneticAccessor(this.getEqHorse());
    private final HorseBreedAccessor breed = new HorseBreedAccessor(this.getEqHorse());
    private final HorseBloodAccessor blood = new HorseBloodAccessor(this.getEqHorse());
    private final HorseConformationAccessor conformation = new HorseConformationAccessor(this.getEqHorse());
    private final HorseLineageAccessor lineage = new HorseLineageAccessor(this.getEqHorse());
    private final HorseRegistrationAccessor registration = new HorseRegistrationAccessor(this.getEqHorse());
    private final HorsePregnancyAccessor pregnancy = new HorsePregnancyAccessor(this.getEqHorse());
    private final HorseCoatAccessor coat = new HorseCoatAccessor(this.getEqHorse());
    private final HorseProvisionAccessor provision = new HorseProvisionAccessor(this.getEqHorse());
    private final HorseSkillAccessor skill = new HorseSkillAccessor(this.getEqHorse());
    private final HorseNutritionAccessor nutrition = new HorseNutritionAccessor(this.getEqHorse());
    private final HorseWeightAccessor weight = new HorseWeightAccessor(this.getEqHorse());
    private final HorseProgressionAccessor progression = new HorseProgressionAccessor(this.getEqHorse());
    private final HorseTrustAccessor trust = new HorseTrustAccessor(this.getEqHorse());
    private final HorseRideTimeAccessor rideTime = new HorseRideTimeAccessor(this.getEqHorse());
    private final HorseWarmUpAccessor warmUp = new HorseWarmUpAccessor(this.getEqHorse());
    private final HorseMetabolismAccessor metabolism = new HorseMetabolismAccessor(this.getEqHorse());
    private final HorseStaminaAccessor stamina = new HorseStaminaAccessor(this.getEqHorse());
    private final HorseIllnessAccessor illness = new HorseIllnessAccessor(this.getEqHorse());
    private final HorseMedicineAccessor medicine = new HorseMedicineAccessor(this.getEqHorse());
    private final HorseHeightAccessor height = new HorseHeightAccessor(this.getEqHorse());
    private final HorseCareAccessor care = new HorseCareAccessor(this.getEqHorse());
    private final HorseMicrochipAccessor microchip = new HorseMicrochipAccessor(this.getEqHorse());
    private final HorseWormerAccessor wormer = new HorseWormerAccessor(this.getEqHorse());
    private final HorseSpayAccessor spay = new HorseSpayAccessor(this.getEqHorse());
    private final HorseCurrentRideAccessor currentRide = new HorseCurrentRideAccessor(this.getEqHorse());
    private final HorseJumpAccessor jump = new HorseJumpAccessor(this.getEqHorse());
    private final HorseFertilityAccessor fertility = new HorseFertilityAccessor(this.getEqHorse());
    private final HorseHealthAccessor health = new HorseHealthAccessor(this.getEqHorse());
    private final HorseBreedingAccessor breeding = new HorseBreedingAccessor(this.getEqHorse());
    private final HorsePrescriptionAccessor prescriptions = new HorsePrescriptionAccessor(this.getEqHorse());
    private final HorseDisciplineAccessor disciplines = new HorseDisciplineAccessor(this.getEqHorse());
    private final HorseBitAccessor bits = new HorseBitAccessor(this.getEqHorse());
    private final HorseShoeAccessor shoes = new HorseShoeAccessor(this.getEqHorse());
    private final HorseDeathAccessor death = new HorseDeathAccessor(this.getEqHorse());
    private final HorseHoovesAccessor hooves = new HorseHoovesAccessor(this.getEqHorse());
    private final HorseHandlingAccessor control = new HorseHandlingAccessor(this.getEqHorse());
    private final HorseStudRegistrationAccessor studRegistration = new HorseStudRegistrationAccessor(this.getEqHorse());
    private final HorseLogAccessor logs = new HorseLogAccessor(this.getEqHorse());
    private final HorseMovementAccessor movement = new HorseMovementAccessor(this.getEqHorse());
    private final HorseEnvironmentAccessor environment = new HorseEnvironmentAccessor(this.getEqHorse());
    private final HorseInstructionAccessor instructions = new HorseInstructionAccessor(this.getEqHorse());
    private final HorseObedienceAccessor obedience = new HorseObedienceAccessor(this.getEqHorse());
    private final HorseGaitAccessor gait = new HorseGaitAccessor(this.getEqHorse());
    private final HorseActionAccessor actions = new HorseActionAccessor(this.getEqHorse());
    private final HorseRelationshipAccessor relationships = new HorseRelationshipAccessor(this.getEqHorse());
    private final HorseTraitAccessor traits = new HorseTraitAccessor(this.getEqHorse());
    private final HorseEnergyAccessor energy = new HorseEnergyAccessor(this.getEqHorse());
    private final HorseStressAccessor stress = new HorseStressAccessor(this.getEqHorse());
    private final HorseAppetiteAccessor appetite = new HorseAppetiteAccessor(this.getEqHorse());
    private final HorseStallRestAccessor stallRest = new HorseStallRestAccessor(this.getEqHorse());
    private final HorseHeartAccessor heart = new HorseHeartAccessor(this.getEqHorse());
    private final HorseTagsAccessor tags = new HorseTagsAccessor(this.getEqHorse());
    private final HorseLocationAccessor location = new HorseLocationAccessor(this.getEqHorse());
    private final HorseOperationAccessor operation = new HorseOperationAccessor(this.getEqHorse());
    private final HorseSymptomAccessor symptoms = new HorseSymptomAccessor(this.getEqHorse());
    private final HorseStatusAccessor status = new HorseStatusAccessor(this.getEqHorse());
    private final HorseFrustrationAccessor frustration = new HorseFrustrationAccessor(this.getEqHorse());
    private final HorseMemoryAccessor memory = new HorseMemoryAccessor(this.getEqHorse());
    private final HorseIntelligenceAccessor intelligence = new HorseIntelligenceAccessor(this.getEqHorse());
    private int mostRecentOwnerId = 0;
    private final CachedValue<ECPlayer> owner = CachedValue.build(this::getCurrentOwner).isExpired(this::isOwnerExpired).complete();
    private static final Log log = Log.getLogger(HorseAdapter.class);

    private ECPlayer getCurrentOwner() {
        this.mostRecentOwnerId = this.getEqHorse().getOwnerId();
        return (ECPlayer)playerRepository.findByKey(this.mostRecentOwnerId);
    }

    private boolean isOwnerExpired() {
        return this.mostRecentOwnerId != this.getEqHorse().getOwnerId();
    }

    public void registerActiveTick(ActiveTickable tick) {
        this.activeTickables.add(tick);
    }

    public void registerAccessor(AbstractHorseAccessor accessor) {
        this.accessors.add(accessor);
    }

    public final String getShowName() {
        return this.getRegistration().getShowName().orElse(null);
    }

    public final ECPlayer getOwner() {
        return this.owner.get();
    }

    public abstract boolean hasParents();

    public final HorseAdapter getMother() {
        if (this.hasParents()) {
            return (HorseAdapter)horseRepository.findByKey(this.getEqHorse().getMotherId());
        }
        return null;
    }

    public final HorseAdapter getFather() {
        if (this.hasParents()) {
            return (HorseAdapter)horseRepository.findByKey(this.getEqHorse().getFatherId());
        }
        return null;
    }

    public final HorseAgeAccessor getAge() {
        return this.age;
    }

    public final HorseAttributesAccessor getAttributes() {
        return this.attributes;
    }

    public final HorseSpeedAccessor getSpeed() {
        return this.speed;
    }

    public final HorseTackAccessor getTacks() {
        return this.tacks;
    }

    public final HorseGeneticAccessor getGenetics() {
        return this.genetics;
    }

    public final HorseBreedAccessor getBreed() {
        return this.breed;
    }

    public final HorseBloodAccessor getBlood() {
        return this.blood;
    }

    public final HorseConformationAccessor getConformation() {
        return this.conformation;
    }

    public final HorseLineageAccessor getLineage() {
        return this.lineage;
    }

    public final HorseRegistrationAccessor getRegistration() {
        return this.registration;
    }

    public final HorsePregnancyAccessor getPregnancy() {
        return this.pregnancy;
    }

    public final HorseCoatAccessor getCoat() {
        return this.coat;
    }

    public final HorseProvisionAccessor getProvision() {
        return this.provision;
    }

    public final HorseSkillAccessor getSkill() {
        return this.skill;
    }

    public final HorseNutritionAccessor getNutrition() {
        return this.nutrition;
    }

    public final HorseWeightAccessor getWeight() {
        return this.weight;
    }

    public final HorseProgressionAccessor getProgression() {
        return this.progression;
    }

    public final HorseTrustAccessor getTrust() {
        return this.trust;
    }

    public final HorseRideTimeAccessor getRideTime() {
        return this.rideTime;
    }

    public final HorseWarmUpAccessor getWarmUp() {
        return this.warmUp;
    }

    public final HorseMetabolismAccessor getMetabolism() {
        return this.metabolism;
    }

    public final HorseStaminaAccessor getStamina() {
        return this.stamina;
    }

    public final HorseIllnessAccessor getIllness() {
        return this.illness;
    }

    public final HorseMedicineAccessor getMedicine() {
        return this.medicine;
    }

    public final HorseHeightAccessor getHeight() {
        return this.height;
    }

    public final HorseCareAccessor getCare() {
        return this.care;
    }

    public final HorseMicrochipAccessor getMicrochip() {
        return this.microchip;
    }

    public final HorseWormerAccessor getWormer() {
        return this.wormer;
    }

    public final HorseSpayAccessor getSpay() {
        return this.spay;
    }

    public final HorseCurrentRideAccessor getCurrentRide() {
        return this.currentRide;
    }

    public final HorseJumpAccessor getJump() {
        return this.jump;
    }

    public final HorseFertilityAccessor getFertility() {
        return this.fertility;
    }

    public final HorseHealthAccessor getHealth() {
        return this.health;
    }

    public final HorseBreedingAccessor getBreeding() {
        return this.breeding;
    }

    public final HorsePrescriptionAccessor getPrescriptions() {
        return this.prescriptions;
    }

    public final HorseDisciplineAccessor getDisciplines() {
        return this.disciplines;
    }

    public final HorseBitAccessor getBits() {
        return this.bits;
    }

    public final HorseShoeAccessor getShoes() {
        return this.shoes;
    }

    public final HorseDeathAccessor getDeath() {
        return this.death;
    }

    public final HorseHoovesAccessor getHooves() {
        return this.hooves;
    }

    public final HorseHandlingAccessor getControl() {
        return this.control;
    }

    public final HorseStudRegistrationAccessor getStudRegistration() {
        return this.studRegistration;
    }

    public final HorseLogAccessor getLogs() {
        return this.logs;
    }

    public HorseMovementAccessor getMovement() {
        return this.movement;
    }

    public HorseEnvironmentAccessor getEnvironment() {
        return this.environment;
    }

    public HorseInstructionAccessor getInstructions() {
        return this.instructions;
    }

    public final HorseObedienceAccessor getObedience() {
        return this.obedience;
    }

    public final HorseGaitAccessor getGait() {
        return this.gait;
    }

    public final HorseActionAccessor getActions() {
        return this.actions;
    }

    public final HorseRelationshipAccessor getRelationships() {
        return this.relationships;
    }

    public final HorseTraitAccessor getTraits() {
        return this.traits;
    }

    public final HorseEnergyAccessor getEnergy() {
        return this.energy;
    }

    public HorseStressAccessor getStress() {
        return this.stress;
    }

    public HorseAppetiteAccessor getAppetite() {
        return this.appetite;
    }

    public HorseStallRestAccessor getStallRest() {
        return this.stallRest;
    }

    public HorseHeartAccessor getHeart() {
        return this.heart;
    }

    public HorseTagsAccessor getTags() {
        return this.tags;
    }

    public HorseLocationAccessor getLocation() {
        return this.location;
    }

    public HorseOperationAccessor getOperation() {
        return this.operation;
    }

    public HorseSymptomAccessor getSymptoms() {
        return this.symptoms;
    }

    public HorseStatusAccessor getStatus() {
        return this.status;
    }

    public HorseFrustrationAccessor getFrustration() {
        return this.frustration;
    }

    public HorseMemoryAccessor getMemory() {
        return this.memory;
    }

    public HorseIntelligenceAccessor getIntelligence() {
        return this.intelligence;
    }

    public final HorseCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public HorseCoatDetails getCoatDetails() {
        return this.getCoat().getDetails();
    }

    @Override
    public final void activeTick() {
        try {
            this.activeTickables.forEach(ActiveTickable::activeTick);
        }
        catch (Exception ex) {
            log.error(String.format("Error while ticking horse data for horse %s", this.getEqHorse().getId()), ex);
        }
    }

    public final void persist() {
        this.accessors.forEach(AbstractHorseAccessor::persist);
    }

    public abstract EQHorse getEqHorse();
}

