/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseGaitVariant;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.HorseOrigin;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.genetic.NumericalGeneticValue;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.shoe.HorseShoeHorse;
import com.equestricraft.core.horse.shoe.HorseShoeHorseDatabase;
import java.sql.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class HorseDatabase
implements RepositoryDatasource<EQHorse, Integer> {
    @Service
    private HorseShoeHorseDatabase horseShoeHorseDatabase;
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_OWNER_ID = "OWNER_ID";
    private static final String COLUMN_GENDER = "GENDER";
    private static final String COLUMN_BREED_CLASSIFIED = "BREED_CLASSIFIED";
    private static final String COLUMN_BIRTH_TIME = "BIRTH_TIME";
    private static final String COLUMN_MOTHER_ID = "MOTHER_ID";
    private static final String COLUMN_FATHER_ID = "FATHER_ID";
    private static final String COLUMN_DEAD = "DEAD";
    private static final String COLUMN_DEATH_TIME = "DEATH_TIME";
    private static final String COLUMN_DEATH_REASON = "DEATH_REASON";
    private static final String COLUMN_DEATH_REGISTERED = "DEATH_REGISTERED";
    private static final String COLUMN_LOCATION = "LOCATION";
    private static final String COLUMN_IMMORTAL = "IMMORTAL";
    private static final String COLUMN_SPAYED_TIME = "SPAYED_TIME";
    private static final String COLUMN_LAST_NUTRITION_REDUCTION = "LAST_NUTRITION_REDUCTION";
    private static final String COLUMN_BASE_METABOLISM_PERCENTAGE_1 = "BASE_METABOLISM_PERCENTAGE_1";
    private static final String COLUMN_BASE_METABOLISM_PERCENTAGE_2 = "BASE_METABOLISM_PERCENTAGE_2";
    private static final String COLUMN_BLOOD_TYPE_ID = "BLOOD_TYPE_ID";
    private static final String COLUMN_SHOW_BLOOD_TYPE_TO_PLAYER = "SHOW_BLOOD_TYPE_TO_PLAYER";
    private static final String COLUMN_XP = "XP";
    private static final String COLUMN_LAST_FEED_TIME_STAMP = "LAST_FEED_TIME_STAMP";
    private static final String COLUMN_LAST_DRINK_TIME_STAMP = "LAST_DRINK_TIME_STAMP";
    private static final String COLUMN_CURRENT_VALUE = "CURRENT_VALUE";
    private static final String COLUMN_GAIT_VARIANT = "GAIT_VARIANT";
    private static final String COLUMN_ORIGIN = "ORIGIN";
    private static final String COLUMN_SHOW_MORE_LINEAGE_INFORMATION = "SHOW_MORE_LINEAGE_INFORMATION";
    private static final String COLUMN_WORMER_DATE = "WORMER_DATE";
    private static final String COLUMN_WORMER_EXPIRY = "WORMER_EXPIRY";
    private static final String COLUMN_MICROCHIP_DATE = "MICROCHIP_DATE";
    private static final String COLUMN_BASE_MAXIMUM_STAMINA_1 = "BASE_MAXIMUM_STAMINA_1";
    private static final String COLUMN_BASE_MAXIMUM_STAMINA_2 = "BASE_MAXIMUM_STAMINA_2";
    private static final String COLUMN_LAST_HOOF_TRIM = "LAST_HOOF_TRIM";
    private static final String COLUMN_BIT_ID = "BIT_ID";
    private static final String COLUMN_BIT_TIME = "BIT_TIME";
    private static final String COLUMN_BIT_END_TIME = "BIT_END_TIME";
    private static final String COLUMN_LAST_DISCIPLINE_CERTIFICATION = "LAST_DISCIPLINE_CERTIFICATION";
    private static final String COLUMN_PREGNANCY_AWARE_TIME = "PREGNANCY_AWARE_TIME";
    private static final String COLUMN_BONNET_ITEM_ID = "BONNET_ITEM_ID";
    private static final String COLUMN_BOOTS_ITEM_ID = "BOOTS_ITEM_ID";
    private static final String COLUMN_BRIDLE_ITEM_ID = "BRIDLE_ITEM_ID";
    private static final String COLUMN_CINCH_ITEM_ID = "CINCH_ITEM_ID";
    private static final String COLUMN_GIRTH_ITEM_ID = "GIRTH_ITEM_ID";
    private static final String COLUMN_HALTER_ITEM_ID = "HALTER_ITEM_ID";
    private static final String COLUMN_PAD_ITEM_ID = "PAD_ITEM_ID";
    private static final String COLUMN_REIN_ITEM_ID = "REIN_ITEM_ID";
    private static final String COLUMN_SADDLE_ITEM_ID = "SADDLE_ITEM_ID";
    private static final String COLUMN_WRAPS_ITEM_ID = "WRAPS_ITEM_ID";
    private static final String COLUMN_CREATED_TIME = "CREATED_TIME";
    private static final String COLUMN_GREY_START_AGE_MONTHS_1 = "GREY_START_AGE_MONTHS_1";
    private static final String COLUMN_GREY_START_AGE_MONTHS_2 = "GREY_START_AGE_MONTHS_2";
    private static final String COLUMN_GREY_FINISH_AGE_MONTHS_1 = "GREY_FINISH_AGE_MONTHS_1";
    private static final String COLUMN_GREY_FINISH_AGE_MONTHS_2 = "GREY_FINISH_AGE_MONTHS_2";
    private static final String COLUMN_LAST_HOOF_CLEAN = "LAST_HOOF_CLEAN";
    private static final String COLUMN_LAST_BRUSH = "LAST_BRUSH";
    private static final String COLUMN_BASE_INTELLIGENCE_1 = "BASE_INTELLIGENCE_1";
    private static final String COLUMN_BASE_INTELLIGENCE_2 = "BASE_INTELLIGENCE_2";
    private static final String COLUMN_BASE_MEMORY_1 = "BASE_MEMORY_1";
    private static final String COLUMN_BASE_MEMORY_2 = "BASE_MEMORY_2";
    private static final String COLUMN_HOOF_WEAR_PERCENTAGE = "HOOF_WEAR_PERCENTAGE";
    private static final String COLUMN_STALL_REST_START = "STALL_REST_START";
    private static final String COLUMN_STALL_REST_END = "STALL_REST_END";
    private static final String COLUMN_FINAL_HEIGHT_1 = "FINAL_HEIGHT_1";
    private static final String COLUMN_FINAL_HEIGHT_2 = "FINAL_HEIGHT_2";
    private static final String COLUMN_FINAL_WEIGHT_1 = "FINAL_WEIGHT_1";
    private static final String COLUMN_FINAL_WEIGHT_2 = "FINAL_WEIGHT_2";
    private static final String COLUMN_OWNED_BY_PLAYER = "OWNED_BY_PLAYER";

    @Override
    public void create(EQHorse horse) {
        Query.insertInto("HORSE").columns(QueryColumn.column(COLUMN_NAME, horse.getName()), QueryColumn.column(COLUMN_OWNER_ID, horse.getOwnerId()), QueryColumn.column(COLUMN_GENDER, horse.getHorseGender()), QueryColumn.column(COLUMN_BREED_CLASSIFIED, horse.isBreedClassified()), QueryColumn.column(COLUMN_BIRTH_TIME, horse.getBirthTime()), QueryColumn.column(COLUMN_MOTHER_ID, horse.getMotherId()), QueryColumn.column(COLUMN_FATHER_ID, horse.getFatherId()), QueryColumn.column(COLUMN_DEAD, horse.isDead()), QueryColumn.column(COLUMN_DEATH_TIME, horse.getDeathTime()), QueryColumn.column(COLUMN_DEATH_REASON, horse.getDeathReason()), QueryColumn.column(COLUMN_DEATH_REGISTERED, horse.isDeathRegistered()), QueryColumn.column(COLUMN_LOCATION, horse.getDirectionalCoordinate()), QueryColumn.column(COLUMN_IMMORTAL, horse.isImmortal()), QueryColumn.column(COLUMN_LAST_NUTRITION_REDUCTION, horse.getLastNutritionReduction()), QueryColumn.column(COLUMN_BASE_METABOLISM_PERCENTAGE_1, ((Number)horse.getBaseMetabolismPercentage().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_BASE_METABOLISM_PERCENTAGE_2, ((Number)horse.getBaseMetabolismPercentage().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_BLOOD_TYPE_ID, horse.getBloodTypeId()), QueryColumn.column(COLUMN_SHOW_BLOOD_TYPE_TO_PLAYER, horse.isShowBloodTypeToPlayer()), QueryColumn.column(COLUMN_XP, horse.getXpValue()), QueryColumn.column(COLUMN_CURRENT_VALUE, horse.getCurrentValue()), QueryColumn.column(COLUMN_GAIT_VARIANT, horse.getGaitVariant()), QueryColumn.column(COLUMN_ORIGIN, horse.getOrigin()), QueryColumn.column(COLUMN_SHOW_MORE_LINEAGE_INFORMATION, horse.isShowMoreLineageInformation()), QueryColumn.column(COLUMN_WORMER_DATE, horse.getWormerDate()), QueryColumn.column(COLUMN_WORMER_EXPIRY, horse.getWormerExpiry()), QueryColumn.column(COLUMN_MICROCHIP_DATE, horse.getMicrochipDate()), QueryColumn.column(COLUMN_BASE_MAXIMUM_STAMINA_1, ((Number)horse.getBaseMaximumStamina().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_BASE_MAXIMUM_STAMINA_2, ((Number)horse.getBaseMaximumStamina().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_LAST_HOOF_TRIM, horse.getLastHoofTrim()), QueryColumn.column(COLUMN_BIT_ID, horse.getBitId()), QueryColumn.column(COLUMN_BIT_TIME, horse.getBitTime()), QueryColumn.column(COLUMN_BIT_END_TIME, horse.getBitEndTime()), QueryColumn.column(COLUMN_LAST_DISCIPLINE_CERTIFICATION, horse.getLastDisciplineCertification()), QueryColumn.column(COLUMN_PREGNANCY_AWARE_TIME, horse.getPregnancyAwareTime()), QueryColumn.column(COLUMN_CREATED_TIME, horse.getCreatedTime()), QueryColumn.column(COLUMN_GREY_START_AGE_MONTHS_1, ((Number)horse.getGreyStartAgeMonths().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_GREY_START_AGE_MONTHS_2, ((Number)horse.getGreyStartAgeMonths().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_GREY_FINISH_AGE_MONTHS_1, ((Number)horse.getGreyFinishAgeMonths().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_GREY_FINISH_AGE_MONTHS_2, ((Number)horse.getGreyFinishAgeMonths().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_LAST_HOOF_CLEAN, horse.getLastHoofClean()), QueryColumn.column(COLUMN_LAST_BRUSH, horse.getLastBrush()), QueryColumn.column(COLUMN_BASE_INTELLIGENCE_1, Float.valueOf(((Number)horse.getBaseIntelligence().getLowerValue()).floatValue())), QueryColumn.column(COLUMN_BASE_INTELLIGENCE_2, Float.valueOf(((Number)horse.getBaseIntelligence().getUpperValue()).floatValue())), QueryColumn.column(COLUMN_BASE_MEMORY_1, Float.valueOf(((Number)horse.getBaseMemory().getLowerValue()).floatValue())), QueryColumn.column(COLUMN_BASE_MEMORY_2, Float.valueOf(((Number)horse.getBaseMemory().getUpperValue()).floatValue())), QueryColumn.column(COLUMN_HOOF_WEAR_PERCENTAGE, horse.getHoofWearPercentage()), QueryColumn.column(COLUMN_STALL_REST_START, horse.getStallRestStart()), QueryColumn.column(COLUMN_STALL_REST_END, horse.getStallRestEnd()), QueryColumn.column(COLUMN_FINAL_HEIGHT_1, ((Number)horse.getBaseHeight().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_FINAL_HEIGHT_2, ((Number)horse.getBaseHeight().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_FINAL_WEIGHT_1, ((Number)horse.getBaseWeight().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_FINAL_WEIGHT_2, ((Number)horse.getBaseWeight().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_OWNED_BY_PLAYER, horse.isOwnedByPlayer())).executeGetGeneratedKey(horse::setId);
    }

    @Override
    public List<EQHorse> retrieveAll() {
        return Query.selectAllFrom("HORSE").getList(this::getHorseFromResultRow);
    }

    private EQHorse getHorseFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        int ownerId = row.getInt(COLUMN_OWNER_ID);
        HorseGender horseGender = row.getEnum(COLUMN_GENDER, HorseGender.class);
        boolean breedClassified = row.getBoolean(COLUMN_BREED_CLASSIFIED);
        java.util.Date birthTime = new java.util.Date(row.getLong(COLUMN_BIRTH_TIME));
        Integer motherId = row.getNullableInt(COLUMN_MOTHER_ID);
        Integer fatherId = row.getNullableInt(COLUMN_FATHER_ID);
        boolean dead = row.getBoolean(COLUMN_DEAD);
        Date deathTime = row.getNullableDate(COLUMN_DEATH_TIME);
        String deathReason = row.getNullableString(COLUMN_DEATH_REASON);
        boolean deathRegistered = row.getBoolean(COLUMN_DEATH_REGISTERED);
        DirectionalCoordinate location = row.getNullableDirectionalCoordinate(COLUMN_LOCATION);
        boolean immortal = row.getBoolean(COLUMN_IMMORTAL);
        Date spayedTime = row.getNullableDate(COLUMN_SPAYED_TIME);
        Date lastNutritionReduction = row.getDate(COLUMN_LAST_NUTRITION_REDUCTION);
        int baseMetabolismPercentage1 = row.getInt(COLUMN_BASE_METABOLISM_PERCENTAGE_1);
        int baseMetabolismPercentage2 = row.getInt(COLUMN_BASE_METABOLISM_PERCENTAGE_2);
        NumericalGeneticValue baseMetabolismPercentage = new NumericalGeneticValue(baseMetabolismPercentage1, baseMetabolismPercentage2);
        int bloodTypeId = row.getInt(COLUMN_BLOOD_TYPE_ID);
        boolean showBloodTypeToPlayer = row.getBoolean(COLUMN_SHOW_BLOOD_TYPE_TO_PLAYER);
        int xp = row.getInt(COLUMN_XP);
        Date lastFeedTimeStamp = row.getNullableDate(COLUMN_LAST_FEED_TIME_STAMP);
        Date lastDrinkTimeStamp = row.getNullableDate(COLUMN_LAST_DRINK_TIME_STAMP);
        double currentValue = row.getDouble(COLUMN_CURRENT_VALUE);
        HorseGaitVariant gaitVariant = row.getEnum(COLUMN_GAIT_VARIANT, HorseGaitVariant.class);
        HorseOrigin origin = row.getEnum(COLUMN_ORIGIN, HorseOrigin.class);
        boolean showMoreLineageInformation = row.getNullableBoolean(COLUMN_SHOW_MORE_LINEAGE_INFORMATION);
        Date wormerDate = row.getNullableDate(COLUMN_WORMER_DATE);
        Date wormerExpiry = row.getNullableDate(COLUMN_WORMER_EXPIRY);
        Date microchipDate = row.getNullableDate(COLUMN_MICROCHIP_DATE);
        long baseMaximumStamina1 = row.getLong(COLUMN_BASE_MAXIMUM_STAMINA_1);
        long baseMaximumStamina2 = row.getLong(COLUMN_BASE_MAXIMUM_STAMINA_2);
        NumericalGeneticValue baseMaximumStamina = new NumericalGeneticValue(baseMaximumStamina1, baseMaximumStamina2);
        long lastHoofTrim = row.getLong(COLUMN_LAST_HOOF_TRIM);
        Optional<HorseShoeHorse> horseShoeHorse = this.horseShoeHorseDatabase.getShoeForHorse(id);
        Integer bitId = row.getNullableInt(COLUMN_BIT_ID);
        Date bitTime = row.getNullableDate(COLUMN_BIT_TIME);
        Date bitEndTime = row.getNullableDate(COLUMN_BIT_END_TIME);
        Date lastDisciplineCertification = row.getNullableDate(COLUMN_LAST_DISCIPLINE_CERTIFICATION);
        Date pregnancyAwareTime = row.getNullableDate(COLUMN_PREGNANCY_AWARE_TIME);
        UUID bonnetId = row.getNullableUuid(COLUMN_BONNET_ITEM_ID);
        UUID bootsId = row.getNullableUuid(COLUMN_BOOTS_ITEM_ID);
        UUID bridleId = row.getNullableUuid(COLUMN_BRIDLE_ITEM_ID);
        UUID cinchId = row.getNullableUuid(COLUMN_CINCH_ITEM_ID);
        UUID girthId = row.getNullableUuid(COLUMN_GIRTH_ITEM_ID);
        UUID halterId = row.getNullableUuid(COLUMN_HALTER_ITEM_ID);
        UUID padId = row.getNullableUuid(COLUMN_PAD_ITEM_ID);
        UUID reinId = row.getNullableUuid(COLUMN_REIN_ITEM_ID);
        UUID saddleId = row.getNullableUuid(COLUMN_SADDLE_ITEM_ID);
        UUID wrapsId = row.getNullableUuid(COLUMN_WRAPS_ITEM_ID);
        Date createdTime = row.getDate(COLUMN_CREATED_TIME);
        int greyStartAgeMonths1 = row.getInt(COLUMN_GREY_START_AGE_MONTHS_1);
        int greyStartAgeMonths2 = row.getInt(COLUMN_GREY_START_AGE_MONTHS_2);
        NumericalGeneticValue greyStartAgeMonths = new NumericalGeneticValue(greyStartAgeMonths1, greyStartAgeMonths2);
        int greyFinishAgeMonths1 = row.getInt(COLUMN_GREY_FINISH_AGE_MONTHS_1);
        int greyFinishAgeMonths2 = row.getInt(COLUMN_GREY_FINISH_AGE_MONTHS_2);
        NumericalGeneticValue greyFinishAgeMonths = new NumericalGeneticValue(greyFinishAgeMonths1, greyFinishAgeMonths2);
        Date lastHoofClean = row.getNullableDate(COLUMN_LAST_HOOF_CLEAN);
        Date lastBrush = row.getNullableDate(COLUMN_LAST_BRUSH);
        float baseIntelligence1 = row.getFloat(COLUMN_BASE_INTELLIGENCE_1);
        float baseIntelligence2 = row.getFloat(COLUMN_BASE_INTELLIGENCE_2);
        NumericalGeneticValue baseIntelligence = new NumericalGeneticValue(Float.valueOf(baseIntelligence1), Float.valueOf(baseIntelligence2));
        float baseMemory1 = row.getFloat(COLUMN_BASE_MEMORY_1);
        float baseMemory2 = row.getFloat(COLUMN_BASE_MEMORY_2);
        NumericalGeneticValue baseMemory = new NumericalGeneticValue(Float.valueOf(baseMemory1), Float.valueOf(baseMemory2));
        double hoofWearPercentage = row.getDouble(COLUMN_HOOF_WEAR_PERCENTAGE);
        Date stallRestStart = row.getNullableDate(COLUMN_STALL_REST_START);
        Date stallRestEnd = row.getNullableDate(COLUMN_STALL_REST_END);
        double finalHeight1 = row.getDouble(COLUMN_FINAL_HEIGHT_1);
        double finalHeight2 = row.getDouble(COLUMN_FINAL_HEIGHT_2);
        NumericalGeneticValue baseHeight = new NumericalGeneticValue(finalHeight1, finalHeight2);
        double finalWeight1 = row.getDouble(COLUMN_FINAL_WEIGHT_1);
        double finalWeight2 = row.getDouble(COLUMN_FINAL_WEIGHT_2);
        boolean ownedByPlayer = row.getBoolean(COLUMN_OWNED_BY_PLAYER);
        NumericalGeneticValue baseWeight = new NumericalGeneticValue(finalWeight1, finalWeight2);
        EQHorse horse = new EQHorse();
        horse.setId(id);
        horse.setName(name);
        horse.setOwnerId(ownerId);
        horse.setHorseGender(horseGender);
        horse.setBreedClassified(breedClassified);
        horse.setBirthTime(birthTime);
        horse.setMotherId(motherId);
        horse.setFatherId(fatherId);
        horse.setDead(dead);
        horse.setDeathTime(deathTime);
        horse.setDeathReason(deathReason);
        horse.setDeathRegistered(deathRegistered);
        horse.setDirectionalCoordinate(location);
        horse.setImmortal(immortal);
        horse.setSpayedTime(spayedTime);
        horse.setLastNutritionReduction(lastNutritionReduction);
        horse.setBaseMetabolismPercentage(baseMetabolismPercentage);
        horse.setBloodTypeId(bloodTypeId);
        horse.setShowBloodTypeToPlayer(showBloodTypeToPlayer);
        horse.setXpValue(xp);
        horse.setLastFeedTimeStamp(lastFeedTimeStamp);
        horse.setLastDrinkTimeStamp(lastDrinkTimeStamp);
        horse.setCurrentValue(currentValue);
        horse.setGaitVariant(gaitVariant);
        horse.setOrigin(origin);
        horse.setShowMoreLineageInformation(showMoreLineageInformation);
        horse.setWormerDate(wormerDate);
        horse.setWormerExpiry(wormerExpiry);
        horse.setMicrochipDate(microchipDate);
        horse.setBaseMaximumStamina(baseMaximumStamina);
        horse.setLastHoofTrim(lastHoofTrim);
        horse.setHorseShoe(horseShoeHorse.orElse(null));
        horse.setBitId(bitId);
        horse.setBitTime(bitTime);
        horse.setBitEndTime(bitEndTime);
        horse.setLastDisciplineCertification(lastDisciplineCertification);
        horse.setPregnancyAwareTime(pregnancyAwareTime);
        horse.setBonnetItemId(bonnetId);
        horse.setBootsItemId(bootsId);
        horse.setBridleItemId(bridleId);
        horse.setCinchItemId(cinchId);
        horse.setGirthItemId(girthId);
        horse.setHalterItemId(halterId);
        horse.setPadItemId(padId);
        horse.setReinItemId(reinId);
        horse.setSaddleItemId(saddleId);
        horse.setWrapsItemId(wrapsId);
        horse.setCreatedTime(createdTime);
        horse.setGreyStartAgeMonths(greyStartAgeMonths);
        horse.setGreyFinishAgeMonths(greyFinishAgeMonths);
        horse.setLastHoofClean(lastHoofClean);
        horse.setLastBrush(lastBrush);
        horse.setBaseIntelligence(baseIntelligence);
        horse.setBaseMemory(baseMemory);
        horse.setHoofWearPercentage(hoofWearPercentage);
        horse.setStallRestStart(stallRestStart);
        horse.setStallRestEnd(stallRestEnd);
        horse.setBaseHeight(baseHeight);
        horse.setBaseWeight(baseWeight);
        horse.setOwnedByPlayer(ownedByPlayer);
        return horse;
    }

    @Override
    public void update(EQHorse horse) {
        Query.update("HORSE").set(QueryColumn.column(COLUMN_NAME, horse.getName()), QueryColumn.column(COLUMN_OWNER_ID, horse.getOwnerId()), QueryColumn.column(COLUMN_GENDER, horse.getHorseGender()), QueryColumn.column(COLUMN_BREED_CLASSIFIED, horse.isBreedClassified()), QueryColumn.column(COLUMN_DEAD, horse.isDead()), QueryColumn.column(COLUMN_DEATH_TIME, horse.getDeathTime()), QueryColumn.column(COLUMN_DEATH_REASON, horse.getDeathReason()), QueryColumn.column(COLUMN_DEATH_REGISTERED, horse.isDeathRegistered()), QueryColumn.column(COLUMN_LOCATION, horse.getDirectionalCoordinate()), QueryColumn.column(COLUMN_IMMORTAL, horse.isImmortal()), QueryColumn.column(COLUMN_SPAYED_TIME, horse.getSpayedTime()), QueryColumn.column(COLUMN_LAST_NUTRITION_REDUCTION, horse.getLastNutritionReduction()), QueryColumn.column(COLUMN_BASE_METABOLISM_PERCENTAGE_1, ((Number)horse.getBaseMetabolismPercentage().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_BASE_METABOLISM_PERCENTAGE_2, ((Number)horse.getBaseMetabolismPercentage().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_BLOOD_TYPE_ID, horse.getBloodTypeId()), QueryColumn.column(COLUMN_SHOW_BLOOD_TYPE_TO_PLAYER, horse.isShowBloodTypeToPlayer()), QueryColumn.column(COLUMN_XP, horse.getXpValue()), QueryColumn.column(COLUMN_CURRENT_VALUE, horse.getCurrentValue()), QueryColumn.column(COLUMN_LAST_FEED_TIME_STAMP, horse.getLastFeedTimeStamp()), QueryColumn.column(COLUMN_LAST_DRINK_TIME_STAMP, horse.getLastDrinkTimeStamp()), QueryColumn.column(COLUMN_GAIT_VARIANT, horse.getGaitVariant()), QueryColumn.column(COLUMN_ORIGIN, horse.getOrigin()), QueryColumn.column(COLUMN_SHOW_MORE_LINEAGE_INFORMATION, horse.isShowMoreLineageInformation()), QueryColumn.column(COLUMN_WORMER_DATE, horse.getWormerDate()), QueryColumn.column(COLUMN_WORMER_EXPIRY, horse.getWormerExpiry()), QueryColumn.column(COLUMN_MICROCHIP_DATE, horse.getMicrochipDate()), QueryColumn.column(COLUMN_BASE_MAXIMUM_STAMINA_1, ((Number)horse.getBaseMaximumStamina().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_BASE_MAXIMUM_STAMINA_2, ((Number)horse.getBaseMaximumStamina().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_LAST_HOOF_TRIM, horse.getLastHoofTrim()), QueryColumn.column(COLUMN_BIT_ID, horse.getBitId()), QueryColumn.column(COLUMN_BIT_TIME, horse.getBitTime()), QueryColumn.column(COLUMN_BIT_END_TIME, horse.getBitEndTime()), QueryColumn.column(COLUMN_LAST_DISCIPLINE_CERTIFICATION, horse.getLastDisciplineCertification()), QueryColumn.column(COLUMN_PREGNANCY_AWARE_TIME, horse.getPregnancyAwareTime()), QueryColumn.column(COLUMN_BONNET_ITEM_ID, horse.getBonnetItemId()), QueryColumn.column(COLUMN_BOOTS_ITEM_ID, horse.getBootsItemId()), QueryColumn.column(COLUMN_BRIDLE_ITEM_ID, horse.getBridleItemId()), QueryColumn.column(COLUMN_CINCH_ITEM_ID, horse.getCinchItemId()), QueryColumn.column(COLUMN_GIRTH_ITEM_ID, horse.getGirthItemId()), QueryColumn.column(COLUMN_HALTER_ITEM_ID, horse.getHalterItemId()), QueryColumn.column(COLUMN_PAD_ITEM_ID, horse.getPadItemId()), QueryColumn.column(COLUMN_REIN_ITEM_ID, horse.getReinItemId()), QueryColumn.column(COLUMN_SADDLE_ITEM_ID, horse.getSaddleItemId()), QueryColumn.column(COLUMN_WRAPS_ITEM_ID, horse.getWrapsItemId()), QueryColumn.column(COLUMN_CREATED_TIME, horse.getCreatedTime()), QueryColumn.column(COLUMN_GREY_START_AGE_MONTHS_1, ((Number)horse.getGreyStartAgeMonths().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_GREY_START_AGE_MONTHS_2, ((Number)horse.getGreyStartAgeMonths().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_GREY_FINISH_AGE_MONTHS_1, ((Number)horse.getGreyFinishAgeMonths().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_GREY_FINISH_AGE_MONTHS_2, ((Number)horse.getGreyFinishAgeMonths().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_LAST_HOOF_CLEAN, horse.getLastHoofClean()), QueryColumn.column(COLUMN_LAST_BRUSH, horse.getLastBrush()), QueryColumn.column(COLUMN_BASE_INTELLIGENCE_1, Float.valueOf(((Number)horse.getBaseIntelligence().getLowerValue()).floatValue())), QueryColumn.column(COLUMN_BASE_INTELLIGENCE_2, Float.valueOf(((Number)horse.getBaseIntelligence().getUpperValue()).floatValue())), QueryColumn.column(COLUMN_BASE_MEMORY_1, Float.valueOf(((Number)horse.getBaseMemory().getLowerValue()).floatValue())), QueryColumn.column(COLUMN_BASE_MEMORY_2, Float.valueOf(((Number)horse.getBaseMemory().getUpperValue()).floatValue())), QueryColumn.column(COLUMN_HOOF_WEAR_PERCENTAGE, horse.getHoofWearPercentage()), QueryColumn.column(COLUMN_STALL_REST_START, horse.getStallRestStart()), QueryColumn.column(COLUMN_STALL_REST_END, horse.getStallRestEnd()), QueryColumn.column(COLUMN_FINAL_HEIGHT_1, ((Number)horse.getBaseHeight().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_FINAL_HEIGHT_2, ((Number)horse.getBaseHeight().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_FINAL_WEIGHT_1, ((Number)horse.getBaseWeight().getLowerValue()).doubleValue()), QueryColumn.column(COLUMN_FINAL_WEIGHT_2, ((Number)horse.getBaseWeight().getUpperValue()).doubleValue()), QueryColumn.column(COLUMN_OWNED_BY_PLAYER, horse.isOwnedByPlayer())).where(QueryColumn.column(COLUMN_ID, horse.getId())).execute();
        if (horse.getHorseShoe() == null) {
            this.horseShoeHorseDatabase.removeShoeForHorse(horse.getId());
        } else {
            this.horseShoeHorseDatabase.addHorseShoeHorse(horse.getId(), horse.getHorseShoe());
        }
    }
}

