/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositoryUpdatePolicy;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseDatabase;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class HorseRepository
extends Repository<EQHorse, Integer> {
    @Service
    private HorseDatabase horseDatabase;

    @Override
    protected RepositoryDatasource<EQHorse, Integer> getDatasource() {
        return this.horseDatabase;
    }

    @Override
    protected RepositoryUpdatePolicy updatePolicy() {
        return RepositoryUpdatePolicy.UPDATE_NOT_ALLOWED;
    }

    @Override
    protected Function<EQHorse, Object> getIndexFunction() {
        return EQHorse::getOwnerId;
    }

    public List<EQHorse> findHorsesByOwner(int ownerId) {
        return this.findListByIndexKey(ownerId).stream().filter(EQHorse::isOwnedByPlayer).toList();
    }

    public List<EQHorse> findLivingHorsesByOwner(int ownerId) {
        return this.findHorsesByOwner(ownerId).stream().filter(Predicate.not(EQHorse::isDead)).toList();
    }

    public List<EQHorse> findDeadHorsesByOwner(int ownerId) {
        return this.findHorsesByOwner(ownerId).stream().filter(EQHorse::isDead).toList();
    }

    public List<EQHorse> findAllLivingHorses() {
        return this.findListByPredicates(Predicate.not(EQHorse::isDead), EQHorse::isOwnedByPlayer);
    }
}

