/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSession;
import com.equestricraft.core.horse.death.ECHorseDeathEvent;
import com.equestricraft.core.horse.death.HorseDeadException;
import com.equestricraft.core.horse.death.HorseDeathAlreadyRegisteredException;
import com.equestricraft.core.horse.death.HorseNotDeadException;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.logging.Log;
import java.util.Date;
import java.util.Objects;

public class HorseSessionImpl
implements HorseSession {
    private static final Log log = Log.getLogger(HorseSessionImpl.class.getName());

    @Override
    public void killHorse(EQHorse horse, String reason) throws HorseDeadException {
        Objects.requireNonNull(reason);
        if (reason.isEmpty()) {
            throw new IllegalArgumentException("Must supply a reason");
        }
        if (reason.length() > 100) {
            throw new IllegalArgumentException("Reason cannot be more than 100 characters");
        }
        if (horse.isDead()) {
            throw new HorseDeadException();
        }
        horse.setDead(true);
        horse.setDeathTime(new Date());
        horse.setDeathReason(reason);
        horse.save();
        log.info("Killed horse {} with reason {}", (Object)horse.getId(), (Object)reason);
        horse.getOwner().notify(I18n.getLabel("horse.died", horse.getName(), reason));
        ECHorseDeathEvent event = new ECHorseDeathEvent(horse);
        ECEventBus.post(event);
    }

    @Override
    public void reviveHorse(EQHorse horse) {
        horse.setDead(false);
        horse.setDeathTime(new Date());
        horse.setDeathReason(null);
        horse.save();
        log.info("Revived horse {}", (Object)horse.getId());
    }

    @Override
    public void registerDeath(EQHorse horse) throws HorseNotDeadException, HorseDeathAlreadyRegisteredException {
        if (FeatureFlag.DEATH_REGISTRATION.isDisabled()) {
            return;
        }
        if (!horse.isDead()) {
            throw new HorseNotDeadException();
        }
        if (horse.isDeathRegistered()) {
            throw new HorseDeathAlreadyRegisteredException();
        }
        horse.setDeathRegistered(true);
        horse.save();
        log.info("Issued death certificate for horse {}", (Object)horse.getId());
    }
}

