/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.access.HorsePlayerAccess;
import com.equestricraft.core.horse.access.HorsePlayerAccessRepository;
import com.equestricraft.core.horse.command.AbstractHorseCommand;
import com.equestricraft.core.horse.sale.log.HorseSaleLogSession;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;

public class HorseTransferCommand
extends AbstractHorseCommand {
    private final ECPlayer newOwner;
    private final double saleValue;
    @Service
    private static HorseRepository horseRepository;
    @Service
    private static HorsePlayerAccessRepository horsePlayerAccessRepository;
    @Service
    private static HorseSaleLogSession horseSaleLogSession;

    public HorseTransferCommand(ECPlayer player, ECPlayer newOwner, double saleValue) {
        super(player);
        this.newOwner = newOwner;
        this.saleValue = saleValue;
    }

    @Override
    protected Response execute() {
        this.horse.setOwnerId(this.newOwner.getId());
        this.horse.save();
        horseRepository.rebuildIndex();
        List<HorsePlayerAccess> accesses = horsePlayerAccessRepository.findAllByHorse(this.horse.getId());
        accesses.forEach(horsePlayerAccessRepository::remove);
        horseSaleLogSession.logSale(this.horse, this.newOwner.getId(), this.saleValue);
        return ResponseFactory.success();
    }
}

