/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.access;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.horse.access.HorsePlayerAccessKey;
import java.util.Objects;

public class HorsePlayerAccess
implements RepositoryEntity<HorsePlayerAccessKey> {
    private final HorsePlayerAccessKey key;
    private final long accessTimeStamp;

    public HorsePlayerAccess(int horseId, int playerId, long accessTimeStamp) {
        this.accessTimeStamp = accessTimeStamp;
        this.key = new HorsePlayerAccessKey(horseId, playerId);
    }

    @Override
    public HorsePlayerAccessKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public long getAccessTimeStamp() {
        return this.accessTimeStamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorsePlayerAccess that = (HorsePlayerAccess)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return this.key.horseId() + " - " + this.key.playerId();
    }
}

