/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.access;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.access.HorsePlayerAccess;
import com.equestricraft.core.horse.access.HorsePlayerAccessKey;
import java.util.List;

public class HorsePlayerAccessDatabase
implements RepositoryDatasource<HorsePlayerAccess, HorsePlayerAccessKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_ACCESS_TIME_STAMP = "ACCESS_TIME_STAMP";

    @Override
    public void create(HorsePlayerAccess horsePlayerAccess) {
        Query.insertInto("HORSE_PLAYER_ACCESS").columns(QueryColumn.column(COLUMN_HORSE_ID, horsePlayerAccess.getHorseId()), QueryColumn.column(COLUMN_PLAYER_ID, horsePlayerAccess.getPlayerId()), QueryColumn.column(COLUMN_ACCESS_TIME_STAMP, horsePlayerAccess.getAccessTimeStamp())).execute();
    }

    @Override
    public List<HorsePlayerAccess> retrieveAll() {
        return Query.selectAllFrom("HORSE_PLAYER_ACCESS").getList(this::getFromResultRow);
    }

    private HorsePlayerAccess getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long accessTimeStamp = row.getLong(COLUMN_ACCESS_TIME_STAMP);
        return new HorsePlayerAccess(horseId, playerId, accessTimeStamp);
    }

    @Override
    public void deleteByKey(HorsePlayerAccessKey horsePlayerAccessKey) {
        Query.deleteFrom("HORSE_PLAYER_ACCESS").where(QueryColumn.column(COLUMN_HORSE_ID, horsePlayerAccessKey.horseId()), QueryColumn.column(COLUMN_PLAYER_ID, horsePlayerAccessKey.playerId())).execute();
    }
}

