/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.access;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.access.HorsePlayerAccessPage;
import com.equestricraft.core.horse.access.HorsePlayerAccessPageService;
import com.equestricraft.core.horse.access.HorsePlayerAccessSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Comparator;
import java.util.List;

public class HorsePlayerAccessPageServiceImpl
extends Pagination<PlayerSimple, HorsePlayerAccessPage, Object, Object>
implements HorsePlayerAccessPageService {
    @Service
    private HorsePlayerAccessSession horsePlayerAccessSession;
    @Service
    private PlayerTransformer playerTransformer;
    private static final int MAXIMUM_PER_PAGE = 10;

    @Override
    public HorsePlayerAccessPage retrieveHorsePlayerAccessPage(EQHorse horse, int pageNumber) {
        List<CorePlayer> players = this.horsePlayerAccessSession.retrievePlayersTrustedOnHorse(horse.getId());
        List<PlayerSimple> entries = this.playerTransformer.toSimpleList(players);
        return (HorsePlayerAccessPage)this.paginate(entries, pageNumber, SortDirection.ASCENDING, null, null);
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(PlayerSimple item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<PlayerSimple> compare(Object sortOrderObject) {
        return Comparator.comparing(PlayerSimple::ign);
    }

    @Override
    protected HorsePlayerAccessPage buildPage(List<PlayerSimple> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new HorsePlayerAccessPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

