/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.access;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.access.HorsePlayerAccess;
import com.equestricraft.core.horse.access.HorsePlayerAccessDatabase;
import com.equestricraft.core.horse.access.HorsePlayerAccessKey;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class HorsePlayerAccessRepository
extends Repository<HorsePlayerAccess, HorsePlayerAccessKey> {
    @Service
    private HorsePlayerAccessDatabase horsePlayerAccessDatabase;

    @Override
    protected RepositoryDatasource<HorsePlayerAccess, HorsePlayerAccessKey> getDatasource() {
        return this.horsePlayerAccessDatabase;
    }

    @Override
    protected Function<HorsePlayerAccess, Object> getIndexFunction() {
        return HorsePlayerAccess::getHorseId;
    }

    public Optional<HorsePlayerAccess> findByHorseAndPlayer(int horseId, int playerId) {
        return this.findByKeyIfExists(new HorsePlayerAccessKey(horseId, playerId));
    }

    public List<HorsePlayerAccess> findAllByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }

    public List<HorsePlayerAccess> findAllByPlayer(int playerId) {
        return this.findListByPredicates((T a) -> a.getPlayerId() == playerId);
    }
}

