/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.access;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.access.HorsePlayerAccess;
import com.equestricraft.core.horse.access.HorsePlayerAccessRepository;
import com.equestricraft.core.horse.access.HorsePlayerAccessSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import java.util.List;

public class HorsePlayerAccessSessionImpl
implements HorsePlayerAccessSession {
    @Service
    private HorsePlayerAccessRepository horsePlayerAccessRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private HorseRepository horseRepository;

    @Override
    public void revokeAllPlayersAccessFromHorse(int horseId) {
        List<HorsePlayerAccess> accesses = this.horsePlayerAccessRepository.findAllByHorse(horseId);
        accesses.forEach(this.horsePlayerAccessRepository::remove);
    }

    @Override
    public boolean isPlayerAddedToHorseAccessList(ECPlayer player, int horseId) {
        return this.horsePlayerAccessRepository.findByHorseAndPlayer(horseId, player.getId()).isPresent();
    }

    @Override
    public List<CorePlayer> retrievePlayersTrustedOnHorse(int horseId) {
        List<HorsePlayerAccess> access = this.horsePlayerAccessRepository.findAllByHorse(horseId);
        List<Integer> playerIds = access.stream().map(HorsePlayerAccess::getPlayerId).toList();
        return this.playerRepository.findByKeys(playerIds);
    }

    @Override
    public List<EQHorse> retrieveHorsesPlayerHasAccessTo(ECPlayer player) {
        List<HorsePlayerAccess> access = this.horsePlayerAccessRepository.findAllByPlayer(player.getId());
        List<Integer> horseIds = access.stream().map(HorsePlayerAccess::getHorseId).toList();
        return this.horseRepository.findByKeys(horseIds);
    }
}

