/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action;

import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class HorseAction<R extends ActionReaction> {
    protected final EQHorse horse;
    protected final ECPlayer performingPlayer;

    protected HorseAction(EQHorse horse) {
        this(horse, null);
    }

    protected HorseAction(EQHorse horse, ECPlayer performingPlayer) {
        this.horse = horse;
        this.performingPlayer = performingPlayer;
    }

    public abstract HorseActionType getType();

    public float getAssociationValueNeeded() {
        return 1.0f;
    }

    public Optional<ECPlayer> getPerformingPlayer() {
        return Optional.ofNullable(this.performingPlayer);
    }

    protected boolean canReject() {
        return false;
    }

    protected boolean forceReject() {
        return false;
    }

    protected boolean affectsTack() {
        return false;
    }

    protected Duration getCoolDownDuration() {
        return Duration.ZERO;
    }

    protected List<ItemTag> getTags() {
        return Collections.emptyList();
    }

    protected void execute(HorseActionExecutePayload payload) {
    }

    protected abstract R buildReaction(boolean var1);

    protected final R rejection() {
        return this.buildReaction(true);
    }

    public abstract String getIdentifier();
}

