/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.core.horse.action.HorseActionRejecter;
import com.equestricraft.core.horse.action.association.HorseActionAssociationSession;
import com.equestricraft.core.horse.action.learnable.LearnableAction;
import com.equestricraft.core.horse.action.learnable.LearnableActionSession;
import com.equestricraft.core.horse.action.log.HorseActionLogSession;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.featureflag.FeatureFlag;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class HorseActionAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseActionLogSession horseActionLogSession;
    @Service
    private static HorseActionAssociationSession horseActionAssociationSession;
    @Service
    private static LearnableActionSession learnableActionSession;
    @Service
    private static ServiceInstance<HorseActionRejecter> horseActionRejecters;
    private final LastRejectNotifyHandler lastRejectNotifyHandler = new LastRejectNotifyHandler();

    public HorseActionAccessor(EQHorse horse) {
        super(horse);
    }

    public <A extends HorseAction<R>, R extends ActionReaction> R processAction(A action) {
        if (this.isWithinCoolDown(action)) {
            this.notifyPlayer(action, I18n.getLabel("horse.action.cool-down"));
            return action.rejection();
        }
        horseActionLogSession.logAction(this.horse, action.getType());
        List<HorseActionType> recentActions = horseActionLogSession.getRecentActions(this.horse);
        for (HorseActionType recentAction : recentActions) {
            horseActionAssociationSession.updateAssociationBetweenActions(this.horse, recentAction, action.getType(), 0.2f);
        }
        List<HorseActionType> associatedActionTypes = horseActionAssociationSession.retrieveAssociatedActions(this.horse, action);
        boolean reject = this.shouldRejectAction(action, associatedActionTypes);
        this.executeLearnedActions(associatedActionTypes);
        List<ItemTag> tackTags = this.getTagsToUpdate(action);
        if (reject) {
            this.notifyPlayer(action, I18n.getLabel("horse.action.rejected"));
            tackTags.forEach(t -> this.horse.getTags().decreaseValueForTag(t.getTagId()));
        } else {
            this.executeAction(action);
            tackTags.forEach(t -> this.horse.getTags().increaseValueForTag(t.getTagId()));
        }
        return action.buildReaction(reject);
    }

    private boolean isWithinCoolDown(HorseAction<?> action) {
        if (action.getCoolDownDuration().isZero()) {
            return false;
        }
        Optional<Duration> durationSinceLast = horseActionLogSession.getDurationSinceActionTypeLastPerformedForHorse(this.horse, action.getType());
        return durationSinceLast.isPresent() && durationSinceLast.get().toMillis() < action.getCoolDownDuration().toMillis();
    }

    private void notifyPlayer(HorseAction<?> action, String message) {
        if (this.lastRejectNotifyHandler.checkNotify(action.getType())) {
            action.getPerformingPlayer().ifPresent(p -> p.sendToast(message));
        }
    }

    private <A extends HorseAction<R>, R extends ActionReaction> boolean shouldRejectAction(A action, List<HorseActionType> associatedActionTypes) {
        if (FeatureFlag.ACTION_REJECT.isDisabled()) {
            return false;
        }
        if (action.forceReject()) {
            return true;
        }
        if (!action.canReject()) {
            return false;
        }
        return this.shouldRejectBasedOnTypes(associatedActionTypes) || this.shouldRejectBasedOnTags(action) || this.shouldRejectBasedOnRejecters(action);
    }

    private <A extends HorseAction<R>, R extends ActionReaction> List<ItemTag> getTagsToUpdate(A action) {
        if (!action.affectsTack()) {
            return Collections.emptyList();
        }
        return this.horse.getTacks().getAllTack().stream().flatMap(t -> ((ECItem)t.tack()).getTags().stream()).toList();
    }

    private boolean shouldRejectBasedOnTags(HorseAction<?> action) {
        double value = 0.0;
        for (ItemTag tag : action.getTags()) {
            value += this.horse.getTags().getValueForTag(tag.getTagId());
        }
        if (value >= 0.0) {
            return false;
        }
        double absValue = Math.abs(value);
        Double percentage = NumberUtils.keepWithinRange(absValue, 0.0, 100.0);
        return ProbabilityUtils.testPercentageProbability(percentage);
    }

    private boolean shouldRejectBasedOnRejecters(HorseAction<?> action) {
        return horseActionRejecters.stream().anyMatch(r -> r.shouldReject(this.horse, action));
    }

    private void executeLearnedActions(List<HorseActionType> associatedActionTypes) {
        if (FeatureFlag.PERFORM_LEARNED_ACTIONS.isDisabled()) {
            return;
        }
        associatedActionTypes.stream().flatMap(a -> learnableActionSession.getLearnableActions(this.horse, (HorseActionType)((Object)a)).stream()).filter(LearnableAction::shouldExecute).forEach(this::executeAction);
    }

    private void executeAction(HorseAction<?> action) {
        HorseActionExecutePayload payload = new HorseActionExecutePayload();
        action.execute(payload);
        this.processTagUpdates(payload);
    }

    private void processTagUpdates(HorseActionExecutePayload payload) {
        Map<UUID, Double> tagUpdates = payload.getTagUpdates();
        for (Map.Entry<UUID, Double> update : tagUpdates.entrySet()) {
            this.horse.getTags().offsetValueForTag(update.getKey(), (double)update.getValue());
        }
    }

    private boolean shouldRejectBasedOnTypes(List<HorseActionType> types) {
        int starting = types.size();
        int score = 0;
        for (HorseActionType associatedAction : types) {
            switch (associatedAction.getPositivity()) {
                case POSITIVE: {
                    score += starting;
                    break;
                }
                case NEGATIVE: {
                    score -= starting;
                    break;
                }
                case NEUTRAL: {
                    score += 0;
                }
            }
            --starting;
        }
        boolean reject = score < 0;
        return reject;
    }

    private static class LastRejectNotifyHandler {
        private final Map<HorseActionType, Long> map = new EnumMap<HorseActionType, Long>(HorseActionType.class);

        private LastRejectNotifyHandler() {
        }

        public synchronized boolean checkNotify(HorseActionType type) {
            Long timeStamp = this.map.get((Object)type);
            if (timeStamp != null && DateUtils.secondsSince(timeStamp) < 5) {
                return false;
            }
            this.map.put(type, System.currentTimeMillis());
            return true;
        }
    }
}

