/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action.association;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.action.association.HorseActionAssociationKey;
import com.equestricraft.core.horse.action.association.HorseActionAssociationRepository;
import java.util.Objects;

public class HorseActionAssociation
implements RepositoryEntity<HorseActionAssociationKey> {
    private final HorseActionAssociationKey key;
    private float value;

    public HorseActionAssociation(int horseId, HorseActionType sourceActionType, HorseActionType targetActionType, float value) {
        if (sourceActionType == targetActionType) {
            throw new IllegalArgumentException("The source action type cannot be the same as the target action type");
        }
        this.key = new HorseActionAssociationKey(horseId, sourceActionType, targetActionType);
        this.value = value;
    }

    @Override
    public HorseActionAssociationKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public HorseActionType getSourceActionType() {
        return this.getKey().sourceActionType();
    }

    public HorseActionType getTargetActionType() {
        return this.getKey().targetActionType();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseActionAssociation that = (HorseActionAssociation)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    @Override
    public void save() {
        Services.getService(HorseActionAssociationRepository.class).update(this);
    }
}

