/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action.association;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.action.association.HorseActionAssociation;
import com.equestricraft.core.horse.action.association.HorseActionAssociationKey;
import java.util.List;

public class HorseActionAssociationDatabase
implements RepositoryDatasource<HorseActionAssociation, HorseActionAssociationKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_SOURCE_ACTION_IDENTIFIER = "SOURCE_ACTION_IDENTIFIER";
    private static final String COLUMN_TARGET_ACTION_IDENTIFIER = "TARGET_ACTION_IDENTIFIER";
    private static final String COLUMN_VALUE = "VALUE";

    @Override
    public void create(HorseActionAssociation horseActionAssociation) {
        Query.insertInto("HORSE_ACTION_ASSOCIATION").columns(QueryColumn.column(COLUMN_HORSE_ID, horseActionAssociation.getHorseId()), QueryColumn.column(COLUMN_SOURCE_ACTION_IDENTIFIER, horseActionAssociation.getSourceActionType()), QueryColumn.column(COLUMN_TARGET_ACTION_IDENTIFIER, horseActionAssociation.getTargetActionType()), QueryColumn.column(COLUMN_VALUE, Float.valueOf(horseActionAssociation.getValue()))).execute();
    }

    @Override
    public List<HorseActionAssociation> retrieveAll() {
        return Query.selectAllFrom("HORSE_ACTION_ASSOCIATION").getList(this::getFromResultRow);
    }

    private HorseActionAssociation getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        HorseActionType sourceAction = row.getEnum(COLUMN_SOURCE_ACTION_IDENTIFIER, HorseActionType.class);
        HorseActionType targetAction = row.getEnum(COLUMN_TARGET_ACTION_IDENTIFIER, HorseActionType.class);
        float value = row.getFloat(COLUMN_VALUE);
        return new HorseActionAssociation(horseId, sourceAction, targetAction, value);
    }

    @Override
    public void update(HorseActionAssociation horseActionAssociation) {
        Query.update("HORSE_ACTION_ASSOCIATION").set(QueryColumn.column(COLUMN_VALUE, Float.valueOf(horseActionAssociation.getValue()))).where(QueryColumn.column(COLUMN_HORSE_ID, horseActionAssociation.getHorseId()), QueryColumn.column(COLUMN_SOURCE_ACTION_IDENTIFIER, horseActionAssociation.getSourceActionType()), QueryColumn.column(COLUMN_TARGET_ACTION_IDENTIFIER, horseActionAssociation.getTargetActionType())).execute();
    }
}

