/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action.association;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.association.HorseActionAssociation;
import com.equestricraft.core.horse.action.association.HorseActionAssociationRepository;
import com.equestricraft.core.horse.action.association.HorseActionAssociationSession;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class HorseActionAssociationSessionImpl
implements HorseActionAssociationSession {
    @Service
    private HorseActionAssociationRepository horseActionAssociationRepository;

    @Override
    public void updateAssociationBetweenActions(EQHorse horse, HorseActionType sourceAction, HorseActionType targetAction, float offsetAmount) {
        if (sourceAction == targetAction) {
            return;
        }
        Optional<HorseActionAssociation> existing = this.horseActionAssociationRepository.findByHorseSourceAndTarget(horse.getId(), sourceAction, targetAction);
        if (existing.isPresent()) {
            HorseActionAssociation association = existing.get();
            float value = association.getValue();
            association.setValue(value += offsetAmount);
            association.save();
        } else {
            HorseActionAssociation association = new HorseActionAssociation(horse.getId(), sourceAction, targetAction, offsetAmount);
            this.horseActionAssociationRepository.add(association);
        }
    }

    @Override
    public List<HorseActionType> retrieveAssociatedActions(EQHorse horse, HorseAction<?> action) {
        List<HorseActionAssociation> associations = this.horseActionAssociationRepository.findByHorseAndSource(horse.getId(), action.getType());
        return associations.stream().filter(assoc -> assoc.getValue() >= action.getAssociationValueNeeded()).sorted(Comparator.comparing(HorseActionAssociation::getValue).reversed()).map(HorseActionAssociation::getTargetActionType).toList();
    }
}

